<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * @subpackage Structs
 */
class Product extends AbstractStructBase
{
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The ProductCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductCode;
    /**
     * The ManageStockLevels
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ManageStockLevels;
    /**
     * The QtyInStock
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $QtyInStock;
    /**
     * The ProductPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ProductPrice;
    /**
     * The ProductName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductName;
    /**
     * The ProductDescription
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProductDescription;
    /**
     * Constructor method for Product
     * @uses Product::setProductID()
     * @uses Product::setProductCode()
     * @uses Product::setManageStockLevels()
     * @uses Product::setQtyInStock()
     * @uses Product::setProductPrice()
     * @uses Product::setProductName()
     * @uses Product::setProductDescription()
     * @param int $productID
     * @param int $productCode
     * @param int $manageStockLevels
     * @param int $qtyInStock
     * @param float $productPrice
     * @param string $productName
     * @param string $productDescription
     */
    public function __construct($productID = null, $productCode = null, $manageStockLevels = null, $qtyInStock = null, $productPrice = null, $productName = null, $productDescription = null)
    {
        $this
            ->setProductID($productID)
            ->setProductCode($productCode)
            ->setManageStockLevels($manageStockLevels)
            ->setQtyInStock($qtyInStock)
            ->setProductPrice($productPrice)
            ->setProductName($productName)
            ->setProductDescription($productDescription);
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \StructType\Product
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get ProductCode value
     * @return int
     */
    public function getProductCode()
    {
        return $this->ProductCode;
    }
    /**
     * Set ProductCode value
     * @param int $productCode
     * @return \StructType\Product
     */
    public function setProductCode($productCode = null)
    {
        // validation for constraint: int
        if (!is_null($productCode) && !is_numeric($productCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productCode)), __LINE__);
        }
        $this->ProductCode = $productCode;
        return $this;
    }
    /**
     * Get ManageStockLevels value
     * @return int
     */
    public function getManageStockLevels()
    {
        return $this->ManageStockLevels;
    }
    /**
     * Set ManageStockLevels value
     * @param int $manageStockLevels
     * @return \StructType\Product
     */
    public function setManageStockLevels($manageStockLevels = null)
    {
        // validation for constraint: int
        if (!is_null($manageStockLevels) && !is_numeric($manageStockLevels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($manageStockLevels)), __LINE__);
        }
        $this->ManageStockLevels = $manageStockLevels;
        return $this;
    }
    /**
     * Get QtyInStock value
     * @return int
     */
    public function getQtyInStock()
    {
        return $this->QtyInStock;
    }
    /**
     * Set QtyInStock value
     * @param int $qtyInStock
     * @return \StructType\Product
     */
    public function setQtyInStock($qtyInStock = null)
    {
        // validation for constraint: int
        if (!is_null($qtyInStock) && !is_numeric($qtyInStock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($qtyInStock)), __LINE__);
        }
        $this->QtyInStock = $qtyInStock;
        return $this;
    }
    /**
     * Get ProductPrice value
     * @return float
     */
    public function getProductPrice()
    {
        return $this->ProductPrice;
    }
    /**
     * Set ProductPrice value
     * @param float $productPrice
     * @return \StructType\Product
     */
    public function setProductPrice($productPrice = null)
    {
        $this->ProductPrice = $productPrice;
        return $this;
    }
    /**
     * Get ProductName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param string $productName
     * @return \StructType\Product
     */
    public function setProductName($productName = null)
    {
        // validation for constraint: string
        if (!is_null($productName) && !is_string($productName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productName)), __LINE__);
        }
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get ProductDescription value
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->ProductDescription;
    }
    /**
     * Set ProductDescription value
     * @param string $productDescription
     * @return \StructType\Product
     */
    public function setProductDescription($productDescription = null)
    {
        // validation for constraint: string
        if (!is_null($productDescription) && !is_string($productDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productDescription)), __LINE__);
        }
        $this->ProductDescription = $productDescription;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
