<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JournalLine StructType
 * @subpackage Structs
 */
class JournalLine extends AbstractStructBase
{
    /**
     * The NominalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NominalID;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Amount;
    /**
     * The ProjId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProjId;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * Constructor method for JournalLine
     * @uses JournalLine::setNominalID()
     * @uses JournalLine::setAmount()
     * @uses JournalLine::setProjId()
     * @uses JournalLine::setComment()
     * @param int $nominalID
     * @param float $amount
     * @param int $projId
     * @param string $comment
     */
    public function __construct($nominalID = null, $amount = null, $projId = null, $comment = null)
    {
        $this
            ->setNominalID($nominalID)
            ->setAmount($amount)
            ->setProjId($projId)
            ->setComment($comment);
    }
    /**
     * Get NominalID value
     * @return int
     */
    public function getNominalID()
    {
        return $this->NominalID;
    }
    /**
     * Set NominalID value
     * @param int $nominalID
     * @return \StructType\JournalLine
     */
    public function setNominalID($nominalID = null)
    {
        // validation for constraint: int
        if (!is_null($nominalID) && !is_numeric($nominalID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nominalID)), __LINE__);
        }
        $this->NominalID = $nominalID;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JournalLine
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get ProjId value
     * @return int
     */
    public function getProjId()
    {
        return $this->ProjId;
    }
    /**
     * Set ProjId value
     * @param int $projId
     * @return \StructType\JournalLine
     */
    public function setProjId($projId = null)
    {
        // validation for constraint: int
        if (!is_null($projId) && !is_numeric($projId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($projId)), __LINE__);
        }
        $this->ProjId = $projId;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \StructType\JournalLine
     */
    public function setComment($comment = null)
    {
        // validation for constraint: string
        if (!is_null($comment) && !is_string($comment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($comment)), __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JournalLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
