<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceLine StructType
 * @subpackage Structs
 */
class InvoiceLine extends AbstractStructBase
{
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Quantity;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Rate;
    /**
     * The ChargeType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ChargeType;
    /**
     * The VatRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatRate;
    /**
     * The VatAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VatAmount;
    /**
     * The ProductID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProductID;
    /**
     * The Sort
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Sort;
    /**
     * The ProjID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProjID;
    /**
     * The LineID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ValuesInCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $ValuesInCurrency;
    /**
     * Constructor method for InvoiceLine
     * @uses InvoiceLine::setQuantity()
     * @uses InvoiceLine::setRate()
     * @uses InvoiceLine::setChargeType()
     * @uses InvoiceLine::setVatRate()
     * @uses InvoiceLine::setVatAmount()
     * @uses InvoiceLine::setProductID()
     * @uses InvoiceLine::setSort()
     * @uses InvoiceLine::setProjID()
     * @uses InvoiceLine::setLineID()
     * @uses InvoiceLine::setDescription()
     * @uses InvoiceLine::setValuesInCurrency()
     * @param float $quantity
     * @param float $rate
     * @param int $chargeType
     * @param float $vatRate
     * @param float $vatAmount
     * @param int $productID
     * @param int $sort
     * @param int $projID
     * @param int $lineID
     * @param string $description
     * @param int $valuesInCurrency
     */
    public function __construct($quantity = null, $rate = null, $chargeType = null, $vatRate = null, $vatAmount = null, $productID = null, $sort = null, $projID = null, $lineID = null, $description = null, $valuesInCurrency = null)
    {
        $this
            ->setQuantity($quantity)
            ->setRate($rate)
            ->setChargeType($chargeType)
            ->setVatRate($vatRate)
            ->setVatAmount($vatAmount)
            ->setProductID($productID)
            ->setSort($sort)
            ->setProjID($projID)
            ->setLineID($lineID)
            ->setDescription($description)
            ->setValuesInCurrency($valuesInCurrency);
    }
    /**
     * Get Quantity value
     * @return float
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\InvoiceLine
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Rate value
     * @return float
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param float $rate
     * @return \StructType\InvoiceLine
     */
    public function setRate($rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Get ChargeType value
     * @return int
     */
    public function getChargeType()
    {
        return $this->ChargeType;
    }
    /**
     * Set ChargeType value
     * @param int $chargeType
     * @return \StructType\InvoiceLine
     */
    public function setChargeType($chargeType = null)
    {
        // validation for constraint: int
        if (!is_null($chargeType) && !is_numeric($chargeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($chargeType)), __LINE__);
        }
        $this->ChargeType = $chargeType;
        return $this;
    }
    /**
     * Get VatRate value
     * @return float
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }
    /**
     * Set VatRate value
     * @param float $vatRate
     * @return \StructType\InvoiceLine
     */
    public function setVatRate($vatRate = null)
    {
        $this->VatRate = $vatRate;
        return $this;
    }
    /**
     * Get VatAmount value
     * @return float
     */
    public function getVatAmount()
    {
        return $this->VatAmount;
    }
    /**
     * Set VatAmount value
     * @param float $vatAmount
     * @return \StructType\InvoiceLine
     */
    public function setVatAmount($vatAmount = null)
    {
        $this->VatAmount = $vatAmount;
        return $this;
    }
    /**
     * Get ProductID value
     * @return int
     */
    public function getProductID()
    {
        return $this->ProductID;
    }
    /**
     * Set ProductID value
     * @param int $productID
     * @return \StructType\InvoiceLine
     */
    public function setProductID($productID = null)
    {
        // validation for constraint: int
        if (!is_null($productID) && !is_numeric($productID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($productID)), __LINE__);
        }
        $this->ProductID = $productID;
        return $this;
    }
    /**
     * Get Sort value
     * @return int
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @param int $sort
     * @return \StructType\InvoiceLine
     */
    public function setSort($sort = null)
    {
        // validation for constraint: int
        if (!is_null($sort) && !is_numeric($sort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($sort)), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get ProjID value
     * @return int
     */
    public function getProjID()
    {
        return $this->ProjID;
    }
    /**
     * Set ProjID value
     * @param int $projID
     * @return \StructType\InvoiceLine
     */
    public function setProjID($projID = null)
    {
        // validation for constraint: int
        if (!is_null($projID) && !is_numeric($projID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($projID)), __LINE__);
        }
        $this->ProjID = $projID;
        return $this;
    }
    /**
     * Get LineID value
     * @return int
     */
    public function getLineID()
    {
        return $this->LineID;
    }
    /**
     * Set LineID value
     * @param int $lineID
     * @return \StructType\InvoiceLine
     */
    public function setLineID($lineID = null)
    {
        // validation for constraint: int
        if (!is_null($lineID) && !is_numeric($lineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineID)), __LINE__);
        }
        $this->LineID = $lineID;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\InvoiceLine
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ValuesInCurrency value
     * @return int|null
     */
    public function getValuesInCurrency()
    {
        return $this->ValuesInCurrency;
    }
    /**
     * Set ValuesInCurrency value
     * @param int $valuesInCurrency
     * @return \StructType\InvoiceLine
     */
    public function setValuesInCurrency($valuesInCurrency = null)
    {
        // validation for constraint: int
        if (!is_null($valuesInCurrency) && !is_numeric($valuesInCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($valuesInCurrency)), __LINE__);
        }
        $this->ValuesInCurrency = $valuesInCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
