<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends AbstractStructBase
{
    /**
     * The InvoiceDBID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceDBID;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InvoiceDate;
    /**
     * The DueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $DueDate;
    /**
     * The CustomerID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CustomerID;
    /**
     * The Paid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Paid;
    /**
     * The SuppressTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SuppressTotal;
    /**
     * The ProjectID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProjectID;
    /**
     * The ExchangeRate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ExchangeRate;
    /**
     * The NetAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NetAmount;
    /**
     * The VATAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $VATAmount;
    /**
     * The AmountPaid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountPaid;
    /**
     * The UseCustomDeliveryAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $UseCustomDeliveryAddress;
    /**
     * The Customer
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Customer;
    /**
     * The CustomerReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerReference;
    /**
     * The EstimateCategory
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstimateCategory;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ReadableString
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReadableString;
    /**
     * The Lines
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfAnyType
     */
    public $Lines;
    /**
     * The CustomerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerName;
    /**
     * The PermaLink
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PermaLink;
    /**
     * The DeliveryAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeliveryAddress
     */
    public $DeliveryAddress;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setInvoiceDBID()
     * @uses Invoice::setInvoiceNumber()
     * @uses Invoice::setInvoiceDate()
     * @uses Invoice::setDueDate()
     * @uses Invoice::setCustomerID()
     * @uses Invoice::setPaid()
     * @uses Invoice::setSuppressTotal()
     * @uses Invoice::setProjectID()
     * @uses Invoice::setExchangeRate()
     * @uses Invoice::setNetAmount()
     * @uses Invoice::setVATAmount()
     * @uses Invoice::setAmountPaid()
     * @uses Invoice::setUseCustomDeliveryAddress()
     * @uses Invoice::setCustomer()
     * @uses Invoice::setCustomerReference()
     * @uses Invoice::setEstimateCategory()
     * @uses Invoice::setCurrencyCode()
     * @uses Invoice::setReadableString()
     * @uses Invoice::setLines()
     * @uses Invoice::setCustomerName()
     * @uses Invoice::setPermaLink()
     * @uses Invoice::setDeliveryAddress()
     * @param int $invoiceDBID
     * @param int $invoiceNumber
     * @param string $invoiceDate
     * @param string $dueDate
     * @param int $customerID
     * @param int $paid
     * @param int $suppressTotal
     * @param int $projectID
     * @param float $exchangeRate
     * @param float $netAmount
     * @param float $vATAmount
     * @param float $amountPaid
     * @param bool $useCustomDeliveryAddress
     * @param string $customer
     * @param string $customerReference
     * @param string $estimateCategory
     * @param string $currencyCode
     * @param string $readableString
     * @param \ArrayType\ArrayOfAnyType $lines
     * @param string $customerName
     * @param string $permaLink
     * @param \StructType\DeliveryAddress $deliveryAddress
     */
    public function __construct($invoiceDBID = null, $invoiceNumber = null, $invoiceDate = null, $dueDate = null, $customerID = null, $paid = null, $suppressTotal = null, $projectID = null, $exchangeRate = null, $netAmount = null, $vATAmount = null, $amountPaid = null, $useCustomDeliveryAddress = null, $customer = null, $customerReference = null, $estimateCategory = null, $currencyCode = null, $readableString = null, \ArrayType\ArrayOfAnyType $lines = null, $customerName = null, $permaLink = null, \StructType\DeliveryAddress $deliveryAddress = null)
    {
        $this
            ->setInvoiceDBID($invoiceDBID)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate)
            ->setDueDate($dueDate)
            ->setCustomerID($customerID)
            ->setPaid($paid)
            ->setSuppressTotal($suppressTotal)
            ->setProjectID($projectID)
            ->setExchangeRate($exchangeRate)
            ->setNetAmount($netAmount)
            ->setVATAmount($vATAmount)
            ->setAmountPaid($amountPaid)
            ->setUseCustomDeliveryAddress($useCustomDeliveryAddress)
            ->setCustomer($customer)
            ->setCustomerReference($customerReference)
            ->setEstimateCategory($estimateCategory)
            ->setCurrencyCode($currencyCode)
            ->setReadableString($readableString)
            ->setLines($lines)
            ->setCustomerName($customerName)
            ->setPermaLink($permaLink)
            ->setDeliveryAddress($deliveryAddress);
    }
    /**
     * Get InvoiceDBID value
     * @return int
     */
    public function getInvoiceDBID()
    {
        return $this->InvoiceDBID;
    }
    /**
     * Set InvoiceDBID value
     * @param int $invoiceDBID
     * @return \StructType\Invoice
     */
    public function setInvoiceDBID($invoiceDBID = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceDBID) && !is_numeric($invoiceDBID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceDBID)), __LINE__);
        }
        $this->InvoiceDBID = $invoiceDBID;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return int
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param int $invoiceNumber
     * @return \StructType\Invoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceNumber) && !is_numeric($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($invoiceNumber)), __LINE__);
        }
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->InvoiceDate;
    }
    /**
     * Set InvoiceDate value
     * @param string $invoiceDate
     * @return \StructType\Invoice
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceDate)), __LINE__);
        }
        $this->InvoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get DueDate value
     * @return string
     */
    public function getDueDate()
    {
        return $this->DueDate;
    }
    /**
     * Set DueDate value
     * @param string $dueDate
     * @return \StructType\Invoice
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dueDate)), __LINE__);
        }
        $this->DueDate = $dueDate;
        return $this;
    }
    /**
     * Get CustomerID value
     * @return int
     */
    public function getCustomerID()
    {
        return $this->CustomerID;
    }
    /**
     * Set CustomerID value
     * @param int $customerID
     * @return \StructType\Invoice
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: int
        if (!is_null($customerID) && !is_numeric($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($customerID)), __LINE__);
        }
        $this->CustomerID = $customerID;
        return $this;
    }
    /**
     * Get Paid value
     * @return int
     */
    public function getPaid()
    {
        return $this->Paid;
    }
    /**
     * Set Paid value
     * @param int $paid
     * @return \StructType\Invoice
     */
    public function setPaid($paid = null)
    {
        // validation for constraint: int
        if (!is_null($paid) && !is_numeric($paid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paid)), __LINE__);
        }
        $this->Paid = $paid;
        return $this;
    }
    /**
     * Get SuppressTotal value
     * @return int
     */
    public function getSuppressTotal()
    {
        return $this->SuppressTotal;
    }
    /**
     * Set SuppressTotal value
     * @param int $suppressTotal
     * @return \StructType\Invoice
     */
    public function setSuppressTotal($suppressTotal = null)
    {
        // validation for constraint: int
        if (!is_null($suppressTotal) && !is_numeric($suppressTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($suppressTotal)), __LINE__);
        }
        $this->SuppressTotal = $suppressTotal;
        return $this;
    }
    /**
     * Get ProjectID value
     * @return int
     */
    public function getProjectID()
    {
        return $this->ProjectID;
    }
    /**
     * Set ProjectID value
     * @param int $projectID
     * @return \StructType\Invoice
     */
    public function setProjectID($projectID = null)
    {
        // validation for constraint: int
        if (!is_null($projectID) && !is_numeric($projectID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($projectID)), __LINE__);
        }
        $this->ProjectID = $projectID;
        return $this;
    }
    /**
     * Get ExchangeRate value
     * @return float
     */
    public function getExchangeRate()
    {
        return $this->ExchangeRate;
    }
    /**
     * Set ExchangeRate value
     * @param float $exchangeRate
     * @return \StructType\Invoice
     */
    public function setExchangeRate($exchangeRate = null)
    {
        $this->ExchangeRate = $exchangeRate;
        return $this;
    }
    /**
     * Get NetAmount value
     * @return float
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param float $netAmount
     * @return \StructType\Invoice
     */
    public function setNetAmount($netAmount = null)
    {
        $this->NetAmount = $netAmount;
        return $this;
    }
    /**
     * Get VATAmount value
     * @return float
     */
    public function getVATAmount()
    {
        return $this->VATAmount;
    }
    /**
     * Set VATAmount value
     * @param float $vATAmount
     * @return \StructType\Invoice
     */
    public function setVATAmount($vATAmount = null)
    {
        $this->VATAmount = $vATAmount;
        return $this;
    }
    /**
     * Get AmountPaid value
     * @return float
     */
    public function getAmountPaid()
    {
        return $this->AmountPaid;
    }
    /**
     * Set AmountPaid value
     * @param float $amountPaid
     * @return \StructType\Invoice
     */
    public function setAmountPaid($amountPaid = null)
    {
        $this->AmountPaid = $amountPaid;
        return $this;
    }
    /**
     * Get UseCustomDeliveryAddress value
     * @return bool
     */
    public function getUseCustomDeliveryAddress()
    {
        return $this->UseCustomDeliveryAddress;
    }
    /**
     * Set UseCustomDeliveryAddress value
     * @param bool $useCustomDeliveryAddress
     * @return \StructType\Invoice
     */
    public function setUseCustomDeliveryAddress($useCustomDeliveryAddress = null)
    {
        // validation for constraint: boolean
        if (!is_null($useCustomDeliveryAddress) && !is_bool($useCustomDeliveryAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($useCustomDeliveryAddress)), __LINE__);
        }
        $this->UseCustomDeliveryAddress = $useCustomDeliveryAddress;
        return $this;
    }
    /**
     * Get Customer value
     * @return string|null
     */
    public function getCustomer()
    {
        return $this->Customer;
    }
    /**
     * Set Customer value
     * @param string $customer
     * @return \StructType\Invoice
     */
    public function setCustomer($customer = null)
    {
        // validation for constraint: string
        if (!is_null($customer) && !is_string($customer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customer)), __LINE__);
        }
        $this->Customer = $customer;
        return $this;
    }
    /**
     * Get CustomerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->CustomerReference;
    }
    /**
     * Set CustomerReference value
     * @param string $customerReference
     * @return \StructType\Invoice
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerReference)), __LINE__);
        }
        $this->CustomerReference = $customerReference;
        return $this;
    }
    /**
     * Get EstimateCategory value
     * @return string|null
     */
    public function getEstimateCategory()
    {
        return $this->EstimateCategory;
    }
    /**
     * Set EstimateCategory value
     * @param string $estimateCategory
     * @return \StructType\Invoice
     */
    public function setEstimateCategory($estimateCategory = null)
    {
        // validation for constraint: string
        if (!is_null($estimateCategory) && !is_string($estimateCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimateCategory)), __LINE__);
        }
        $this->EstimateCategory = $estimateCategory;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \StructType\Invoice
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currencyCode)), __LINE__);
        }
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get ReadableString value
     * @return string|null
     */
    public function getReadableString()
    {
        return $this->ReadableString;
    }
    /**
     * Set ReadableString value
     * @param string $readableString
     * @return \StructType\Invoice
     */
    public function setReadableString($readableString = null)
    {
        // validation for constraint: string
        if (!is_null($readableString) && !is_string($readableString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($readableString)), __LINE__);
        }
        $this->ReadableString = $readableString;
        return $this;
    }
    /**
     * Get Lines value
     * @return \ArrayType\ArrayOfAnyType|null
     */
    public function getLines()
    {
        return $this->Lines;
    }
    /**
     * Set Lines value
     * @param \ArrayType\ArrayOfAnyType $lines
     * @return \StructType\Invoice
     */
    public function setLines(\ArrayType\ArrayOfAnyType $lines = null)
    {
        $this->Lines = $lines;
        return $this;
    }
    /**
     * Get CustomerName value
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->CustomerName;
    }
    /**
     * Set CustomerName value
     * @param string $customerName
     * @return \StructType\Invoice
     */
    public function setCustomerName($customerName = null)
    {
        // validation for constraint: string
        if (!is_null($customerName) && !is_string($customerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerName)), __LINE__);
        }
        $this->CustomerName = $customerName;
        return $this;
    }
    /**
     * Get PermaLink value
     * @return string|null
     */
    public function getPermaLink()
    {
        return $this->PermaLink;
    }
    /**
     * Set PermaLink value
     * @param string $permaLink
     * @return \StructType\Invoice
     */
    public function setPermaLink($permaLink = null)
    {
        // validation for constraint: string
        if (!is_null($permaLink) && !is_string($permaLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($permaLink)), __LINE__);
        }
        $this->PermaLink = $permaLink;
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * @return \StructType\DeliveryAddress|null
     */
    public function getDeliveryAddress()
    {
        return $this->DeliveryAddress;
    }
    /**
     * Set DeliveryAddress value
     * @param \StructType\DeliveryAddress $deliveryAddress
     * @return \StructType\Invoice
     */
    public function setDeliveryAddress(\StructType\DeliveryAddress $deliveryAddress = null)
    {
        $this->DeliveryAddress = $deliveryAddress;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Invoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
