<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReceiptsWithPagingResponse StructType
 * @subpackage Structs
 */
class GetReceiptsWithPagingResponse extends AbstractStructBase
{
    /**
     * The PageNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PageNumber;
    /**
     * The TotalPages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalPages;
    /**
     * The TotalRecords
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TotalRecords;
    /**
     * The GetReceiptsWithPagingResult
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInvoice
     */
    public $GetReceiptsWithPagingResult;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Status;
    /**
     * The StatusDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusDetail;
    /**
     * Constructor method for GetReceiptsWithPagingResponse
     * @uses GetReceiptsWithPagingResponse::setPageNumber()
     * @uses GetReceiptsWithPagingResponse::setTotalPages()
     * @uses GetReceiptsWithPagingResponse::setTotalRecords()
     * @uses GetReceiptsWithPagingResponse::setGetReceiptsWithPagingResult()
     * @uses GetReceiptsWithPagingResponse::setStatus()
     * @uses GetReceiptsWithPagingResponse::setStatusDetail()
     * @param int $pageNumber
     * @param int $totalPages
     * @param int $totalRecords
     * @param \ArrayType\ArrayOfInvoice $getReceiptsWithPagingResult
     * @param string $status
     * @param string $statusDetail
     */
    public function __construct($pageNumber = null, $totalPages = null, $totalRecords = null, \ArrayType\ArrayOfInvoice $getReceiptsWithPagingResult = null, $status = null, $statusDetail = null)
    {
        $this
            ->setPageNumber($pageNumber)
            ->setTotalPages($totalPages)
            ->setTotalRecords($totalRecords)
            ->setGetReceiptsWithPagingResult($getReceiptsWithPagingResult)
            ->setStatus($status)
            ->setStatusDetail($statusDetail);
    }
    /**
     * Get PageNumber value
     * @return int
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \StructType\GetReceiptsWithPagingResponse
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !is_numeric($pageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get TotalPages value
     * @return int
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }
    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return \StructType\GetReceiptsWithPagingResponse
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !is_numeric($totalPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }
    /**
     * Get TotalRecords value
     * @return int
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\GetReceiptsWithPagingResponse
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !is_numeric($totalRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get GetReceiptsWithPagingResult value
     * @return \ArrayType\ArrayOfInvoice|null
     */
    public function getGetReceiptsWithPagingResult()
    {
        return $this->GetReceiptsWithPagingResult;
    }
    /**
     * Set GetReceiptsWithPagingResult value
     * @param \ArrayType\ArrayOfInvoice $getReceiptsWithPagingResult
     * @return \StructType\GetReceiptsWithPagingResponse
     */
    public function setGetReceiptsWithPagingResult(\ArrayType\ArrayOfInvoice $getReceiptsWithPagingResult = null)
    {
        $this->GetReceiptsWithPagingResult = $getReceiptsWithPagingResult;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\GetReceiptsWithPagingResponse
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get StatusDetail value
     * @return string|null
     */
    public function getStatusDetail()
    {
        return $this->StatusDetail;
    }
    /**
     * Set StatusDetail value
     * @param string $statusDetail
     * @return \StructType\GetReceiptsWithPagingResponse
     */
    public function setStatusDetail($statusDetail = null)
    {
        // validation for constraint: string
        if (!is_null($statusDetail) && !is_string($statusDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($statusDetail)), __LINE__);
        }
        $this->StatusDetail = $statusDetail;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetReceiptsWithPagingResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
