<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetProjects_Full StructType
 * @subpackage Structs
 */
class GetProjects_Full extends AbstractStructBase
{
    /**
     * The ProjStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ProjStatus;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for GetProjects_Full
     * @uses GetProjects_Full::setProjStatus()
     * @uses GetProjects_Full::setUserName()
     * @uses GetProjects_Full::setPassword()
     * @param int $projStatus
     * @param string $userName
     * @param string $password
     */
    public function __construct($projStatus = null, $userName = null, $password = null)
    {
        $this
            ->setProjStatus($projStatus)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get ProjStatus value
     * @return int
     */
    public function getProjStatus()
    {
        return $this->ProjStatus;
    }
    /**
     * Set ProjStatus value
     * @param int $projStatus
     * @return \StructType\GetProjects_Full
     */
    public function setProjStatus($projStatus = null)
    {
        // validation for constraint: int
        if (!is_null($projStatus) && !is_numeric($projStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($projStatus)), __LINE__);
        }
        $this->ProjStatus = $projStatus;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\GetProjects_Full
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\GetProjects_Full
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetProjects_Full
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
