<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeleteReceiptLineWithReceiptID StructType
 * @subpackage Structs
 */
class DeleteReceiptLineWithReceiptID extends AbstractStructBase
{
    /**
     * The LineID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $LineID;
    /**
     * The ReceiptID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ReceiptID;
    /**
     * The UserName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserName;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * Constructor method for DeleteReceiptLineWithReceiptID
     * @uses DeleteReceiptLineWithReceiptID::setLineID()
     * @uses DeleteReceiptLineWithReceiptID::setReceiptID()
     * @uses DeleteReceiptLineWithReceiptID::setUserName()
     * @uses DeleteReceiptLineWithReceiptID::setPassword()
     * @param int $lineID
     * @param int $receiptID
     * @param string $userName
     * @param string $password
     */
    public function __construct($lineID = null, $receiptID = null, $userName = null, $password = null)
    {
        $this
            ->setLineID($lineID)
            ->setReceiptID($receiptID)
            ->setUserName($userName)
            ->setPassword($password);
    }
    /**
     * Get LineID value
     * @return int
     */
    public function getLineID()
    {
        return $this->LineID;
    }
    /**
     * Set LineID value
     * @param int $lineID
     * @return \StructType\DeleteReceiptLineWithReceiptID
     */
    public function setLineID($lineID = null)
    {
        // validation for constraint: int
        if (!is_null($lineID) && !is_numeric($lineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($lineID)), __LINE__);
        }
        $this->LineID = $lineID;
        return $this;
    }
    /**
     * Get ReceiptID value
     * @return int
     */
    public function getReceiptID()
    {
        return $this->ReceiptID;
    }
    /**
     * Set ReceiptID value
     * @param int $receiptID
     * @return \StructType\DeleteReceiptLineWithReceiptID
     */
    public function setReceiptID($receiptID = null)
    {
        // validation for constraint: int
        if (!is_null($receiptID) && !is_numeric($receiptID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($receiptID)), __LINE__);
        }
        $this->ReceiptID = $receiptID;
        return $this;
    }
    /**
     * Get UserName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->UserName;
    }
    /**
     * Set UserName value
     * @param string $userName
     * @return \StructType\DeleteReceiptLineWithReceiptID
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userName)), __LINE__);
        }
        $this->UserName = $userName;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\DeleteReceiptLineWithReceiptID
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteReceiptLineWithReceiptID
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
