<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for createAccount StructType
 * @subpackage Structs
 */
class CreateAccount extends AbstractStructBase
{
    /**
     * The VATRegistered
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VATRegistered;
    /**
     * The USSettings
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $USSettings;
    /**
     * The AccountCreationKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountCreationKey;
    /**
     * The Username
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Username;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The memorableword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $memorableword;
    /**
     * The EmailAddress
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EmailAddress;
    /**
     * The CompanyName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CompanyName;
    /**
     * The Addr1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Addr1;
    /**
     * The Addr2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Addr2;
    /**
     * The Addr3
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Addr3;
    /**
     * The Addr4
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Addr4;
    /**
     * The Postcode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Postcode;
    /**
     * The ContactName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telephone;
    /**
     * The VATNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VATNumber;
    /**
     * The promocode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $promocode;
    /**
     * Constructor method for createAccount
     * @uses CreateAccount::setVATRegistered()
     * @uses CreateAccount::setUSSettings()
     * @uses CreateAccount::setAccountCreationKey()
     * @uses CreateAccount::setUsername()
     * @uses CreateAccount::setPassword()
     * @uses CreateAccount::setMemorableword()
     * @uses CreateAccount::setEmailAddress()
     * @uses CreateAccount::setCompanyName()
     * @uses CreateAccount::setAddr1()
     * @uses CreateAccount::setAddr2()
     * @uses CreateAccount::setAddr3()
     * @uses CreateAccount::setAddr4()
     * @uses CreateAccount::setPostcode()
     * @uses CreateAccount::setContactName()
     * @uses CreateAccount::setTelephone()
     * @uses CreateAccount::setVATNumber()
     * @uses CreateAccount::setPromocode()
     * @param int $vATRegistered
     * @param int $uSSettings
     * @param string $accountCreationKey
     * @param string $username
     * @param string $password
     * @param string $memorableword
     * @param string $emailAddress
     * @param string $companyName
     * @param string $addr1
     * @param string $addr2
     * @param string $addr3
     * @param string $addr4
     * @param string $postcode
     * @param string $contactName
     * @param string $telephone
     * @param string $vATNumber
     * @param string $promocode
     */
    public function __construct($vATRegistered = null, $uSSettings = null, $accountCreationKey = null, $username = null, $password = null, $memorableword = null, $emailAddress = null, $companyName = null, $addr1 = null, $addr2 = null, $addr3 = null, $addr4 = null, $postcode = null, $contactName = null, $telephone = null, $vATNumber = null, $promocode = null)
    {
        $this
            ->setVATRegistered($vATRegistered)
            ->setUSSettings($uSSettings)
            ->setAccountCreationKey($accountCreationKey)
            ->setUsername($username)
            ->setPassword($password)
            ->setMemorableword($memorableword)
            ->setEmailAddress($emailAddress)
            ->setCompanyName($companyName)
            ->setAddr1($addr1)
            ->setAddr2($addr2)
            ->setAddr3($addr3)
            ->setAddr4($addr4)
            ->setPostcode($postcode)
            ->setContactName($contactName)
            ->setTelephone($telephone)
            ->setVATNumber($vATNumber)
            ->setPromocode($promocode);
    }
    /**
     * Get VATRegistered value
     * @return int
     */
    public function getVATRegistered()
    {
        return $this->VATRegistered;
    }
    /**
     * Set VATRegistered value
     * @param int $vATRegistered
     * @return \StructType\CreateAccount
     */
    public function setVATRegistered($vATRegistered = null)
    {
        // validation for constraint: int
        if (!is_null($vATRegistered) && !is_numeric($vATRegistered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vATRegistered)), __LINE__);
        }
        $this->VATRegistered = $vATRegistered;
        return $this;
    }
    /**
     * Get USSettings value
     * @return int
     */
    public function getUSSettings()
    {
        return $this->USSettings;
    }
    /**
     * Set USSettings value
     * @param int $uSSettings
     * @return \StructType\CreateAccount
     */
    public function setUSSettings($uSSettings = null)
    {
        // validation for constraint: int
        if (!is_null($uSSettings) && !is_numeric($uSSettings)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($uSSettings)), __LINE__);
        }
        $this->USSettings = $uSSettings;
        return $this;
    }
    /**
     * Get AccountCreationKey value
     * @return string|null
     */
    public function getAccountCreationKey()
    {
        return $this->AccountCreationKey;
    }
    /**
     * Set AccountCreationKey value
     * @param string $accountCreationKey
     * @return \StructType\CreateAccount
     */
    public function setAccountCreationKey($accountCreationKey = null)
    {
        // validation for constraint: string
        if (!is_null($accountCreationKey) && !is_string($accountCreationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountCreationKey)), __LINE__);
        }
        $this->AccountCreationKey = $accountCreationKey;
        return $this;
    }
    /**
     * Get Username value
     * @return string|null
     */
    public function getUsername()
    {
        return $this->Username;
    }
    /**
     * Set Username value
     * @param string $username
     * @return \StructType\CreateAccount
     */
    public function setUsername($username = null)
    {
        // validation for constraint: string
        if (!is_null($username) && !is_string($username)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($username)), __LINE__);
        }
        $this->Username = $username;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\CreateAccount
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get memorableword value
     * @return string|null
     */
    public function getMemorableword()
    {
        return $this->memorableword;
    }
    /**
     * Set memorableword value
     * @param string $memorableword
     * @return \StructType\CreateAccount
     */
    public function setMemorableword($memorableword = null)
    {
        // validation for constraint: string
        if (!is_null($memorableword) && !is_string($memorableword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($memorableword)), __LINE__);
        }
        $this->memorableword = $memorableword;
        return $this;
    }
    /**
     * Get EmailAddress value
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->EmailAddress;
    }
    /**
     * Set EmailAddress value
     * @param string $emailAddress
     * @return \StructType\CreateAccount
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($emailAddress)), __LINE__);
        }
        $this->EmailAddress = $emailAddress;
        return $this;
    }
    /**
     * Get CompanyName value
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param string $companyName
     * @return \StructType\CreateAccount
     */
    public function setCompanyName($companyName = null)
    {
        // validation for constraint: string
        if (!is_null($companyName) && !is_string($companyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($companyName)), __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Addr1 value
     * @return string|null
     */
    public function getAddr1()
    {
        return $this->Addr1;
    }
    /**
     * Set Addr1 value
     * @param string $addr1
     * @return \StructType\CreateAccount
     */
    public function setAddr1($addr1 = null)
    {
        // validation for constraint: string
        if (!is_null($addr1) && !is_string($addr1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr1)), __LINE__);
        }
        $this->Addr1 = $addr1;
        return $this;
    }
    /**
     * Get Addr2 value
     * @return string|null
     */
    public function getAddr2()
    {
        return $this->Addr2;
    }
    /**
     * Set Addr2 value
     * @param string $addr2
     * @return \StructType\CreateAccount
     */
    public function setAddr2($addr2 = null)
    {
        // validation for constraint: string
        if (!is_null($addr2) && !is_string($addr2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr2)), __LINE__);
        }
        $this->Addr2 = $addr2;
        return $this;
    }
    /**
     * Get Addr3 value
     * @return string|null
     */
    public function getAddr3()
    {
        return $this->Addr3;
    }
    /**
     * Set Addr3 value
     * @param string $addr3
     * @return \StructType\CreateAccount
     */
    public function setAddr3($addr3 = null)
    {
        // validation for constraint: string
        if (!is_null($addr3) && !is_string($addr3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr3)), __LINE__);
        }
        $this->Addr3 = $addr3;
        return $this;
    }
    /**
     * Get Addr4 value
     * @return string|null
     */
    public function getAddr4()
    {
        return $this->Addr4;
    }
    /**
     * Set Addr4 value
     * @param string $addr4
     * @return \StructType\CreateAccount
     */
    public function setAddr4($addr4 = null)
    {
        // validation for constraint: string
        if (!is_null($addr4) && !is_string($addr4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addr4)), __LINE__);
        }
        $this->Addr4 = $addr4;
        return $this;
    }
    /**
     * Get Postcode value
     * @return string|null
     */
    public function getPostcode()
    {
        return $this->Postcode;
    }
    /**
     * Set Postcode value
     * @param string $postcode
     * @return \StructType\CreateAccount
     */
    public function setPostcode($postcode = null)
    {
        // validation for constraint: string
        if (!is_null($postcode) && !is_string($postcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postcode)), __LINE__);
        }
        $this->Postcode = $postcode;
        return $this;
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\CreateAccount
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return string|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param string $telephone
     * @return \StructType\CreateAccount
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($telephone)), __LINE__);
        }
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get VATNumber value
     * @return string|null
     */
    public function getVATNumber()
    {
        return $this->VATNumber;
    }
    /**
     * Set VATNumber value
     * @param string $vATNumber
     * @return \StructType\CreateAccount
     */
    public function setVATNumber($vATNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vATNumber) && !is_string($vATNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vATNumber)), __LINE__);
        }
        $this->VATNumber = $vATNumber;
        return $this;
    }
    /**
     * Get promocode value
     * @return string|null
     */
    public function getPromocode()
    {
        return $this->promocode;
    }
    /**
     * Set promocode value
     * @param string $promocode
     * @return \StructType\CreateAccount
     */
    public function setPromocode($promocode = null)
    {
        // validation for constraint: string
        if (!is_null($promocode) && !is_string($promocode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($promocode)), __LINE__);
        }
        $this->promocode = $promocode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreateAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
