<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountOverview StructType
 * @subpackage Structs
 */
class AccountOverview extends AbstractStructBase
{
    /**
     * The TotalDue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalDue;
    /**
     * The TotalOwed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $TotalOwed;
    /**
     * The ReceiptsOverdue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReceiptsOverdue;
    /**
     * The SalesOverdue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $SalesOverdue;
    /**
     * The ReceiptPartPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReceiptPartPayments;
    /**
     * The ReceiptPartPaymentsOverdue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ReceiptPartPaymentsOverdue;
    /**
     * The InvoicePartPayments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InvoicePartPayments;
    /**
     * The InvoicePartPaymentsOverdue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $InvoicePartPaymentsOverdue;
    /**
     * Constructor method for AccountOverview
     * @uses AccountOverview::setTotalDue()
     * @uses AccountOverview::setTotalOwed()
     * @uses AccountOverview::setReceiptsOverdue()
     * @uses AccountOverview::setSalesOverdue()
     * @uses AccountOverview::setReceiptPartPayments()
     * @uses AccountOverview::setReceiptPartPaymentsOverdue()
     * @uses AccountOverview::setInvoicePartPayments()
     * @uses AccountOverview::setInvoicePartPaymentsOverdue()
     * @param float $totalDue
     * @param float $totalOwed
     * @param float $receiptsOverdue
     * @param float $salesOverdue
     * @param float $receiptPartPayments
     * @param float $receiptPartPaymentsOverdue
     * @param float $invoicePartPayments
     * @param float $invoicePartPaymentsOverdue
     */
    public function __construct($totalDue = null, $totalOwed = null, $receiptsOverdue = null, $salesOverdue = null, $receiptPartPayments = null, $receiptPartPaymentsOverdue = null, $invoicePartPayments = null, $invoicePartPaymentsOverdue = null)
    {
        $this
            ->setTotalDue($totalDue)
            ->setTotalOwed($totalOwed)
            ->setReceiptsOverdue($receiptsOverdue)
            ->setSalesOverdue($salesOverdue)
            ->setReceiptPartPayments($receiptPartPayments)
            ->setReceiptPartPaymentsOverdue($receiptPartPaymentsOverdue)
            ->setInvoicePartPayments($invoicePartPayments)
            ->setInvoicePartPaymentsOverdue($invoicePartPaymentsOverdue);
    }
    /**
     * Get TotalDue value
     * @return float
     */
    public function getTotalDue()
    {
        return $this->TotalDue;
    }
    /**
     * Set TotalDue value
     * @param float $totalDue
     * @return \StructType\AccountOverview
     */
    public function setTotalDue($totalDue = null)
    {
        $this->TotalDue = $totalDue;
        return $this;
    }
    /**
     * Get TotalOwed value
     * @return float
     */
    public function getTotalOwed()
    {
        return $this->TotalOwed;
    }
    /**
     * Set TotalOwed value
     * @param float $totalOwed
     * @return \StructType\AccountOverview
     */
    public function setTotalOwed($totalOwed = null)
    {
        $this->TotalOwed = $totalOwed;
        return $this;
    }
    /**
     * Get ReceiptsOverdue value
     * @return float
     */
    public function getReceiptsOverdue()
    {
        return $this->ReceiptsOverdue;
    }
    /**
     * Set ReceiptsOverdue value
     * @param float $receiptsOverdue
     * @return \StructType\AccountOverview
     */
    public function setReceiptsOverdue($receiptsOverdue = null)
    {
        $this->ReceiptsOverdue = $receiptsOverdue;
        return $this;
    }
    /**
     * Get SalesOverdue value
     * @return float
     */
    public function getSalesOverdue()
    {
        return $this->SalesOverdue;
    }
    /**
     * Set SalesOverdue value
     * @param float $salesOverdue
     * @return \StructType\AccountOverview
     */
    public function setSalesOverdue($salesOverdue = null)
    {
        $this->SalesOverdue = $salesOverdue;
        return $this;
    }
    /**
     * Get ReceiptPartPayments value
     * @return float
     */
    public function getReceiptPartPayments()
    {
        return $this->ReceiptPartPayments;
    }
    /**
     * Set ReceiptPartPayments value
     * @param float $receiptPartPayments
     * @return \StructType\AccountOverview
     */
    public function setReceiptPartPayments($receiptPartPayments = null)
    {
        $this->ReceiptPartPayments = $receiptPartPayments;
        return $this;
    }
    /**
     * Get ReceiptPartPaymentsOverdue value
     * @return float
     */
    public function getReceiptPartPaymentsOverdue()
    {
        return $this->ReceiptPartPaymentsOverdue;
    }
    /**
     * Set ReceiptPartPaymentsOverdue value
     * @param float $receiptPartPaymentsOverdue
     * @return \StructType\AccountOverview
     */
    public function setReceiptPartPaymentsOverdue($receiptPartPaymentsOverdue = null)
    {
        $this->ReceiptPartPaymentsOverdue = $receiptPartPaymentsOverdue;
        return $this;
    }
    /**
     * Get InvoicePartPayments value
     * @return float
     */
    public function getInvoicePartPayments()
    {
        return $this->InvoicePartPayments;
    }
    /**
     * Set InvoicePartPayments value
     * @param float $invoicePartPayments
     * @return \StructType\AccountOverview
     */
    public function setInvoicePartPayments($invoicePartPayments = null)
    {
        $this->InvoicePartPayments = $invoicePartPayments;
        return $this;
    }
    /**
     * Get InvoicePartPaymentsOverdue value
     * @return float
     */
    public function getInvoicePartPaymentsOverdue()
    {
        return $this->InvoicePartPaymentsOverdue;
    }
    /**
     * Set InvoicePartPaymentsOverdue value
     * @param float $invoicePartPaymentsOverdue
     * @return \StructType\AccountOverview
     */
    public function setInvoicePartPaymentsOverdue($invoicePartPaymentsOverdue = null)
    {
        $this->InvoicePartPaymentsOverdue = $invoicePartPaymentsOverdue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountOverview
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
