<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UpdateCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCustomer $parameters
     * @return \StructType\UpdateCustomerResponse|bool
     */
    public function UpdateCustomer(\StructType\UpdateCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateSupplier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateSupplier $parameters
     * @return \StructType\UpdateSupplierResponse|bool
     */
    public function UpdateSupplier(\StructType\UpdateSupplier $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateSupplier($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateBankTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateBankTransaction $parameters
     * @return \StructType\UpdateBankTransactionResponse|bool
     */
    public function UpdateBankTransaction(\StructType\UpdateBankTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateBankTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateJournal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateJournal $parameters
     * @return \StructType\UpdateJournalResponse|bool
     */
    public function UpdateJournal(\StructType\UpdateJournal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateJournal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateJournalHeader
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateJournalHeader $parameters
     * @return \StructType\UpdateJournalHeaderResponse|bool
     */
    public function UpdateJournalHeader(\StructType\UpdateJournalHeader $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateJournalHeader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateQuote $parameters
     * @return \StructType\UpdateQuoteResponse|bool
     */
    public function UpdateQuote(\StructType\UpdateQuote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateQuoteHeader
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateQuoteHeader $parameters
     * @return \StructType\UpdateQuoteHeaderResponse|bool
     */
    public function UpdateQuoteHeader(\StructType\UpdateQuoteHeader $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateQuoteHeader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateInvoice $parameters
     * @return \StructType\UpdateInvoiceResponse|bool
     */
    public function UpdateInvoice(\StructType\UpdateInvoice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInvoice_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateInvoice_TypeDefined $parameters
     * @return \StructType\UpdateInvoice_TypeDefinedResponse|bool
     */
    public function UpdateInvoice_TypeDefined(\StructType\UpdateInvoice_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateInvoice_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateInvoiceHeader
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateInvoiceHeader $parameters
     * @return \StructType\UpdateInvoiceHeaderResponse|bool
     */
    public function UpdateInvoiceHeader(\StructType\UpdateInvoiceHeader $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateInvoiceHeader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateReceipt_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateReceipt_TypeDefined $parameters
     * @return \StructType\UpdateReceipt_TypeDefinedResponse|bool
     */
    public function UpdateReceipt_TypeDefined(\StructType\UpdateReceipt_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateReceipt_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateReceipt $parameters
     * @return \StructType\UpdateReceiptResponse|bool
     */
    public function UpdateReceipt(\StructType\UpdateReceipt $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateReceiptHeader
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateReceiptHeader $parameters
     * @return \StructType\UpdateReceiptHeaderResponse|bool
     */
    public function UpdateReceiptHeader(\StructType\UpdateReceiptHeader $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->UpdateReceiptHeader($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateBankTransactionResponse|\StructType\UpdateCustomerResponse|\StructType\UpdateInvoiceHeaderResponse|\StructType\UpdateInvoiceResponse|\StructType\UpdateInvoice_TypeDefinedResponse|\StructType\UpdateJournalHeaderResponse|\StructType\UpdateJournalResponse|\StructType\UpdateQuoteHeaderResponse|\StructType\UpdateQuoteResponse|\StructType\UpdateReceiptHeaderResponse|\StructType\UpdateReceiptResponse|\StructType\UpdateReceipt_TypeDefinedResponse|\StructType\UpdateSupplierResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
