<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Insert ServiceType
 * @subpackage Services
 */
class Insert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InsertOrUpdateProject
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertOrUpdateProject $parameters
     * @return \StructType\InsertOrUpdateProjectResponse|bool
     */
    public function InsertOrUpdateProject(\StructType\InsertOrUpdateProject $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertOrUpdateProject($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertSupplier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertSupplier $parameters
     * @return \StructType\InsertSupplierResponse|bool
     */
    public function InsertSupplier(\StructType\InsertSupplier $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertSupplier($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertBankTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertBankTransaction $parameters
     * @return \StructType\InsertBankTransactionResponse|bool
     */
    public function InsertBankTransaction(\StructType\InsertBankTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertBankTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertJournal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertJournal $parameters
     * @return \StructType\InsertJournalResponse|bool
     */
    public function InsertJournal(\StructType\InsertJournal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertJournal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertNominalCode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertNominalCode $parameters
     * @return \StructType\InsertNominalCodeResponse|bool
     */
    public function InsertNominalCode(\StructType\InsertNominalCode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertNominalCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertQuote $parameters
     * @return \StructType\InsertQuoteResponse|bool
     */
    public function InsertQuote(\StructType\InsertQuote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertQuoteLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertQuoteLine $parameters
     * @return \StructType\InsertQuoteLineResponse|bool
     */
    public function InsertQuoteLine(\StructType\InsertQuoteLine $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertQuoteLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertInvoice $parameters
     * @return \StructType\InsertInvoiceResponse|bool
     */
    public function InsertInvoice(\StructType\InsertInvoice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertInvoice_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertInvoice_TypeDefined $parameters
     * @return \StructType\InsertInvoice_TypeDefinedResponse|bool
     */
    public function InsertInvoice_TypeDefined(\StructType\InsertInvoice_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertInvoice_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertInvoiceLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertInvoiceLine $parameters
     * @return \StructType\InsertInvoiceLineResponse|bool
     */
    public function InsertInvoiceLine(\StructType\InsertInvoiceLine $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertInvoiceLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertInvoiceLineWithInvoiceNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertInvoiceLineWithInvoiceNumber $parameters
     * @return \StructType\InsertInvoiceLineWithInvoiceNumberResponse|bool
     */
    public function InsertInvoiceLineWithInvoiceNumber(\StructType\InsertInvoiceLineWithInvoiceNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertInvoiceLineWithInvoiceNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertInvoicePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertInvoicePayment $parameters
     * @return \StructType\InsertInvoicePaymentResponse|bool
     */
    public function InsertInvoicePayment(\StructType\InsertInvoicePayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertInvoicePayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertInvoiceNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertInvoiceNote $parameters
     * @return \StructType\InsertInvoiceNoteResponse|bool
     */
    public function InsertInvoiceNote(\StructType\InsertInvoiceNote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertInvoiceNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertReceipt_TypeDefined
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertReceipt_TypeDefined $parameters
     * @return \StructType\InsertReceipt_TypeDefinedResponse|bool
     */
    public function InsertReceipt_TypeDefined(\StructType\InsertReceipt_TypeDefined $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertReceipt_TypeDefined($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertReceipt $parameters
     * @return \StructType\InsertReceiptResponse|bool
     */
    public function InsertReceipt(\StructType\InsertReceipt $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertReceiptLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertReceiptLine $parameters
     * @return \StructType\InsertReceiptLineResponse|bool
     */
    public function InsertReceiptLine(\StructType\InsertReceiptLine $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertReceiptLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertReceiptLineFromNumber
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertReceiptLineFromNumber $parameters
     * @return \StructType\InsertReceiptLineFromNumberResponse|bool
     */
    public function InsertReceiptLineFromNumber(\StructType\InsertReceiptLineFromNumber $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertReceiptLineFromNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertReceiptPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertReceiptPayment $parameters
     * @return \StructType\InsertReceiptPaymentResponse|bool
     */
    public function InsertReceiptPayment(\StructType\InsertReceiptPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertReceiptPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertReceiptNote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertReceiptNote $parameters
     * @return \StructType\InsertReceiptNoteResponse|bool
     */
    public function InsertReceiptNote(\StructType\InsertReceiptNote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertReceiptNote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InsertCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InsertCustomer $parameters
     * @return \StructType\InsertCustomerResponse|bool
     */
    public function InsertCustomer(\StructType\InsertCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->InsertCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InsertBankTransactionResponse|\StructType\InsertCustomerResponse|\StructType\InsertInvoiceLineResponse|\StructType\InsertInvoiceLineWithInvoiceNumberResponse|\StructType\InsertInvoiceNoteResponse|\StructType\InsertInvoicePaymentResponse|\StructType\InsertInvoiceResponse|\StructType\InsertInvoice_TypeDefinedResponse|\StructType\InsertJournalResponse|\StructType\InsertNominalCodeResponse|\StructType\InsertOrUpdateProjectResponse|\StructType\InsertQuoteLineResponse|\StructType\InsertQuoteResponse|\StructType\InsertReceiptLineFromNumberResponse|\StructType\InsertReceiptLineResponse|\StructType\InsertReceiptNoteResponse|\StructType\InsertReceiptPaymentResponse|\StructType\InsertReceiptResponse|\StructType\InsertReceipt_TypeDefinedResponse|\StructType\InsertSupplierResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
