<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeleteCustomer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteCustomer $parameters
     * @return \StructType\DeleteCustomerResponse|bool
     */
    public function DeleteCustomer(\StructType\DeleteCustomer $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteCustomer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteSupplier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteSupplier $parameters
     * @return \StructType\DeleteSupplierResponse|bool
     */
    public function DeleteSupplier(\StructType\DeleteSupplier $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteSupplier($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteBankTransaction
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteBankTransaction $parameters
     * @return \StructType\DeleteBankTransactionResponse|bool
     */
    public function DeleteBankTransaction(\StructType\DeleteBankTransaction $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteBankTransaction($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteJournal
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteJournal $parameters
     * @return \StructType\DeleteJournalResponse|bool
     */
    public function DeleteJournal(\StructType\DeleteJournal $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteJournal($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteJournalByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteJournalByID $parameters
     * @return \StructType\DeleteJournalByIDResponse|bool
     */
    public function DeleteJournalByID(\StructType\DeleteJournalByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteJournalByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteReceiptAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteReceiptAttachment $parameters
     * @return \StructType\DeleteReceiptAttachmentResponse|bool
     */
    public function DeleteReceiptAttachment(\StructType\DeleteReceiptAttachment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteReceiptAttachment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteQuote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteQuote $parameters
     * @return \StructType\DeleteQuoteResponse|bool
     */
    public function DeleteQuote(\StructType\DeleteQuote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteQuote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteQuoteByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteQuoteByID $parameters
     * @return \StructType\DeleteQuoteByIDResponse|bool
     */
    public function DeleteQuoteByID(\StructType\DeleteQuoteByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteQuoteByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteQuoteLineWithQuoteID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteQuoteLineWithQuoteID $parameters
     * @return \StructType\DeleteQuoteLineWithQuoteIDResponse|bool
     */
    public function DeleteQuoteLineWithQuoteID(\StructType\DeleteQuoteLineWithQuoteID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteQuoteLineWithQuoteID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteQuoteLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteQuoteLine $parameters
     * @return \StructType\DeleteQuoteLineResponse|bool
     */
    public function DeleteQuoteLine(\StructType\DeleteQuoteLine $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteQuoteLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteInvoicePayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteInvoicePayment $parameters
     * @return \StructType\DeleteInvoicePaymentResponse|bool
     */
    public function DeleteInvoicePayment(\StructType\DeleteInvoicePayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteInvoicePayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteInvoice $parameters
     * @return \StructType\DeleteInvoiceResponse|bool
     */
    public function DeleteInvoice(\StructType\DeleteInvoice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteInvoiceByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteInvoiceByID $parameters
     * @return \StructType\DeleteInvoiceByIDResponse|bool
     */
    public function DeleteInvoiceByID(\StructType\DeleteInvoiceByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteInvoiceByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteInvoiceLineWithInvoiceID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteInvoiceLineWithInvoiceID $parameters
     * @return \StructType\DeleteInvoiceLineWithInvoiceIDResponse|bool
     */
    public function DeleteInvoiceLineWithInvoiceID(\StructType\DeleteInvoiceLineWithInvoiceID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteInvoiceLineWithInvoiceID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteInvoiceLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteInvoiceLine $parameters
     * @return \StructType\DeleteInvoiceLineResponse|bool
     */
    public function DeleteInvoiceLine(\StructType\DeleteInvoiceLine $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteInvoiceLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteReceipt
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteReceipt $parameters
     * @return \StructType\DeleteReceiptResponse|bool
     */
    public function DeleteReceipt(\StructType\DeleteReceipt $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteReceiptByID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteReceiptByID $parameters
     * @return \StructType\DeleteReceiptByIDResponse|bool
     */
    public function DeleteReceiptByID(\StructType\DeleteReceiptByID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteReceiptByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteReceiptLine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteReceiptLine $parameters
     * @return \StructType\DeleteReceiptLineResponse|bool
     */
    public function DeleteReceiptLine(\StructType\DeleteReceiptLine $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteReceiptLine($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteReceiptLineWithReceiptID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteReceiptLineWithReceiptID $parameters
     * @return \StructType\DeleteReceiptLineWithReceiptIDResponse|bool
     */
    public function DeleteReceiptLineWithReceiptID(\StructType\DeleteReceiptLineWithReceiptID $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteReceiptLineWithReceiptID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DeleteReceiptPayment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeleteReceiptPayment $parameters
     * @return \StructType\DeleteReceiptPaymentResponse|bool
     */
    public function DeleteReceiptPayment(\StructType\DeleteReceiptPayment $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DeleteReceiptPayment($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeleteBankTransactionResponse|\StructType\DeleteCustomerResponse|\StructType\DeleteInvoiceByIDResponse|\StructType\DeleteInvoiceLineResponse|\StructType\DeleteInvoiceLineWithInvoiceIDResponse|\StructType\DeleteInvoicePaymentResponse|\StructType\DeleteInvoiceResponse|\StructType\DeleteJournalByIDResponse|\StructType\DeleteJournalResponse|\StructType\DeleteQuoteByIDResponse|\StructType\DeleteQuoteLineResponse|\StructType\DeleteQuoteLineWithQuoteIDResponse|\StructType\DeleteQuoteResponse|\StructType\DeleteReceiptAttachmentResponse|\StructType\DeleteReceiptByIDResponse|\StructType\DeleteReceiptLineResponse|\StructType\DeleteReceiptLineWithReceiptIDResponse|\StructType\DeleteReceiptPaymentResponse|\StructType\DeleteReceiptResponse|\StructType\DeleteSupplierResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
