<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfInvoiceNotes ArrayType
 * @subpackage Arrays
 */
class ArrayOfInvoiceNotes extends AbstractStructArrayBase
{
    /**
     * The InvoiceNotes
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceNotes[]
     */
    public $InvoiceNotes;
    /**
     * Constructor method for ArrayOfInvoiceNotes
     * @uses ArrayOfInvoiceNotes::setInvoiceNotes()
     * @param \StructType\InvoiceNotes[] $invoiceNotes
     */
    public function __construct(array $invoiceNotes = array())
    {
        $this
            ->setInvoiceNotes($invoiceNotes);
    }
    /**
     * Get InvoiceNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceNotes[]|null
     */
    public function getInvoiceNotes()
    {
        return isset($this->InvoiceNotes) ? $this->InvoiceNotes : null;
    }
    /**
     * Set InvoiceNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceNotes[] $invoiceNotes
     * @return \ArrayType\ArrayOfInvoiceNotes
     */
    public function setInvoiceNotes(array $invoiceNotes = array())
    {
        foreach ($invoiceNotes as $arrayOfInvoiceNotesInvoiceNotesItem) {
            // validation for constraint: itemType
            if (!$arrayOfInvoiceNotesInvoiceNotesItem instanceof \StructType\InvoiceNotes) {
                throw new \InvalidArgumentException(sprintf('The InvoiceNotes property can only contain items of \StructType\InvoiceNotes, "%s" given', is_object($arrayOfInvoiceNotesInvoiceNotesItem) ? get_class($arrayOfInvoiceNotesInvoiceNotesItem) : gettype($arrayOfInvoiceNotesInvoiceNotesItem)), __LINE__);
            }
        }
        if (is_null($invoiceNotes) || (is_array($invoiceNotes) && empty($invoiceNotes))) {
            unset($this->InvoiceNotes);
        } else {
            $this->InvoiceNotes = $invoiceNotes;
        }
        return $this;
    }
    /**
     * Add item to InvoiceNotes value
     * @throws \InvalidArgumentException
     * @param \StructType\InvoiceNotes $item
     * @return \ArrayType\ArrayOfInvoiceNotes
     */
    public function addToInvoiceNotes(\StructType\InvoiceNotes $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InvoiceNotes) {
            throw new \InvalidArgumentException(sprintf('The InvoiceNotes property can only contain items of \StructType\InvoiceNotes, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvoiceNotes[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\InvoiceNotes|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\InvoiceNotes|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\InvoiceNotes|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\InvoiceNotes|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\InvoiceNotes|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string InvoiceNotes
     */
    public function getAttributeName()
    {
        return 'InvoiceNotes';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfInvoiceNotes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
