<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCurrencies ArrayType
 * @subpackage Arrays
 */
class ArrayOfCurrencies extends AbstractStructArrayBase
{
    /**
     * The Currencies
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Currencies[]
     */
    public $Currencies;
    /**
     * Constructor method for ArrayOfCurrencies
     * @uses ArrayOfCurrencies::setCurrencies()
     * @param \StructType\Currencies[] $currencies
     */
    public function __construct(array $currencies = array())
    {
        $this
            ->setCurrencies($currencies);
    }
    /**
     * Get Currencies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Currencies[]|null
     */
    public function getCurrencies()
    {
        return isset($this->Currencies) ? $this->Currencies : null;
    }
    /**
     * Set Currencies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Currencies[] $currencies
     * @return \ArrayType\ArrayOfCurrencies
     */
    public function setCurrencies(array $currencies = array())
    {
        foreach ($currencies as $arrayOfCurrenciesCurrenciesItem) {
            // validation for constraint: itemType
            if (!$arrayOfCurrenciesCurrenciesItem instanceof \StructType\Currencies) {
                throw new \InvalidArgumentException(sprintf('The Currencies property can only contain items of \StructType\Currencies, "%s" given', is_object($arrayOfCurrenciesCurrenciesItem) ? get_class($arrayOfCurrenciesCurrenciesItem) : gettype($arrayOfCurrenciesCurrenciesItem)), __LINE__);
            }
        }
        if (is_null($currencies) || (is_array($currencies) && empty($currencies))) {
            unset($this->Currencies);
        } else {
            $this->Currencies = $currencies;
        }
        return $this;
    }
    /**
     * Add item to Currencies value
     * @throws \InvalidArgumentException
     * @param \StructType\Currencies $item
     * @return \ArrayType\ArrayOfCurrencies
     */
    public function addToCurrencies(\StructType\Currencies $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Currencies) {
            throw new \InvalidArgumentException(sprintf('The Currencies property can only contain items of \StructType\Currencies, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Currencies[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Currencies|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Currencies|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Currencies|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Currencies|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Currencies|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Currencies
     */
    public function getAttributeName()
    {
        return 'Currencies';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfCurrencies
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
