<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBankOverview ArrayType
 * @subpackage Arrays
 */
class ArrayOfBankOverview extends AbstractStructArrayBase
{
    /**
     * The BankOverview
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BankOverview[]
     */
    public $BankOverview;
    /**
     * Constructor method for ArrayOfBankOverview
     * @uses ArrayOfBankOverview::setBankOverview()
     * @param \StructType\BankOverview[] $bankOverview
     */
    public function __construct(array $bankOverview = array())
    {
        $this
            ->setBankOverview($bankOverview);
    }
    /**
     * Get BankOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BankOverview[]|null
     */
    public function getBankOverview()
    {
        return isset($this->BankOverview) ? $this->BankOverview : null;
    }
    /**
     * Set BankOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BankOverview[] $bankOverview
     * @return \ArrayType\ArrayOfBankOverview
     */
    public function setBankOverview(array $bankOverview = array())
    {
        foreach ($bankOverview as $arrayOfBankOverviewBankOverviewItem) {
            // validation for constraint: itemType
            if (!$arrayOfBankOverviewBankOverviewItem instanceof \StructType\BankOverview) {
                throw new \InvalidArgumentException(sprintf('The BankOverview property can only contain items of \StructType\BankOverview, "%s" given', is_object($arrayOfBankOverviewBankOverviewItem) ? get_class($arrayOfBankOverviewBankOverviewItem) : gettype($arrayOfBankOverviewBankOverviewItem)), __LINE__);
            }
        }
        if (is_null($bankOverview) || (is_array($bankOverview) && empty($bankOverview))) {
            unset($this->BankOverview);
        } else {
            $this->BankOverview = $bankOverview;
        }
        return $this;
    }
    /**
     * Add item to BankOverview value
     * @throws \InvalidArgumentException
     * @param \StructType\BankOverview $item
     * @return \ArrayType\ArrayOfBankOverview
     */
    public function addToBankOverview(\StructType\BankOverview $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BankOverview) {
            throw new \InvalidArgumentException(sprintf('The BankOverview property can only contain items of \StructType\BankOverview, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->BankOverview[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BankOverview|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BankOverview|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BankOverview|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BankOverview|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BankOverview|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BankOverview
     */
    public function getAttributeName()
    {
        return 'BankOverview';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfBankOverview
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
