<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Type StructType
 * @subpackage Structs
 */
class Type extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The SourceInvoice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $SourceInvoice;
    /**
     * Constructor method for Type
     * @uses Type::setType()
     * @uses Type::setSourceInvoice()
     * @param string $type
     * @param string $sourceInvoice
     */
    public function __construct($type = null, $sourceInvoice = null)
    {
        $this
            ->setType($type)
            ->setSourceInvoice($sourceInvoice);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Lib\OmnivaService\StructType\Type
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get SourceInvoice value
     * @return string|null
     */
    public function getSourceInvoice()
    {
        return $this->SourceInvoice;
    }
    /**
     * Set SourceInvoice value
     * @param string $sourceInvoice
     * @return \Lib\OmnivaService\StructType\Type
     */
    public function setSourceInvoice($sourceInvoice = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($sourceInvoice) && strlen($sourceInvoice) > 20) || (is_array($sourceInvoice) && count($sourceInvoice) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($sourceInvoice) ? strlen($sourceInvoice) : count($sourceInvoice)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($sourceInvoice) && !is_string($sourceInvoice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sourceInvoice)), __LINE__);
        }
        $this->SourceInvoice = $sourceInvoice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\Type
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
