<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimpleResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Represents simple response with code and message
 * @subpackage Structs
 */
class SimpleResponseType extends AbstractStructBase
{
    /**
     * The ErrorCode
     * Meta informations extracted from the WSDL
     * - documentation: "0" indicates successful transmission, any other integer indicates an error code
     * @var int
     */
    public $ErrorCode;
    /**
     * The Message
     * Meta informations extracted from the WSDL
     * - documentation: Human readable error/success message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for SimpleResponseType
     * @uses SimpleResponseType::setErrorCode()
     * @uses SimpleResponseType::setMessage()
     * @param int $errorCode
     * @param string $message
     */
    public function __construct($errorCode = null, $message = null)
    {
        $this
            ->setErrorCode($errorCode)
            ->setMessage($message);
    }
    /**
     * Get ErrorCode value
     * @return int|null
     */
    public function getErrorCode()
    {
        return $this->ErrorCode;
    }
    /**
     * Set ErrorCode value
     * @param int $errorCode
     * @return \Lib\OmnivaService\StructType\SimpleResponseType
     */
    public function setErrorCode($errorCode = null)
    {
        // validation for constraint: int
        if (!is_null($errorCode) && !is_numeric($errorCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($errorCode)), __LINE__);
        }
        $this->ErrorCode = $errorCode;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Lib\OmnivaService\StructType\SimpleResponseType
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\SimpleResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
