<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleInvoiceExportReqType StructType
 * @subpackage Structs
 */
class SaleInvoiceExportReqType extends AbstractStructBase
{
    /**
     * The since
     * Meta informations extracted from the WSDL
     * - documentation: Only consider changes that have been made in EAK after this date. Invoices whose state has changed after this datum are returned.
     * - use: required
     * @var string
     */
    public $since;
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - documentation: Only sale invoices with this state are returned (if any).
     * @var string
     */
    public $state;
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $format;
    /**
     * Constructor method for SaleInvoiceExportReqType
     * @uses SaleInvoiceExportReqType::setSince()
     * @uses SaleInvoiceExportReqType::setAuthPhrase()
     * @uses SaleInvoiceExportReqType::setState()
     * @uses SaleInvoiceExportReqType::setFormat()
     * @param string $since
     * @param string $authPhrase
     * @param string $state
     * @param string $format
     */
    public function __construct($since = null, $authPhrase = null, $state = null, $format = null)
    {
        $this
            ->setSince($since)
            ->setAuthPhrase($authPhrase)
            ->setState($state)
            ->setFormat($format);
    }
    /**
     * Get since value
     * @return string
     */
    public function getSince()
    {
        return $this->since;
    }
    /**
     * Set since value
     * @param string $since
     * @return \Lib\OmnivaService\StructType\SaleInvoiceExportReqType
     */
    public function setSince($since = null)
    {
        // validation for constraint: string
        if (!is_null($since) && !is_string($since)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($since)), __LINE__);
        }
        $this->since = $since;
        return $this;
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\SaleInvoiceExportReqType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \Lib\OmnivaService\EnumType\SaleInvoiceStateType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\SaleInvoiceStateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \Lib\OmnivaService\StructType\SaleInvoiceExportReqType
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\SaleInvoiceStateType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \Lib\OmnivaService\EnumType\SaleInvoiceStateType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Get format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Lib\OmnivaService\EnumType\InvoiceFormatType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\InvoiceFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Lib\OmnivaService\StructType\SaleInvoiceExportReqType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\InvoiceFormatType::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $format, implode(', ', \Lib\OmnivaService\EnumType\InvoiceFormatType::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\SaleInvoiceExportReqType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
