<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleInvoiceBuyStatusType StructType
 * @subpackage Structs
 */
class SaleInvoiceBuyStatusType extends AbstractStructBase
{
    /**
     * The changeId
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $changeId;
    /**
     * The changeDateTime
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $changeDateTime;
    /**
     * The invoiceNr
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $invoiceNr;
    /**
     * The invoiceDate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $invoiceDate;
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $event;
    /**
     * The infoCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $infoCode;
    /**
     * The infoText
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 500
     * @var string
     */
    public $infoText;
    /**
     * Constructor method for SaleInvoiceBuyStatusType
     * @uses SaleInvoiceBuyStatusType::setChangeId()
     * @uses SaleInvoiceBuyStatusType::setChangeDateTime()
     * @uses SaleInvoiceBuyStatusType::setInvoiceNr()
     * @uses SaleInvoiceBuyStatusType::setInvoiceDate()
     * @uses SaleInvoiceBuyStatusType::setEvent()
     * @uses SaleInvoiceBuyStatusType::setInfoCode()
     * @uses SaleInvoiceBuyStatusType::setInfoText()
     * @param int $changeId
     * @param string $changeDateTime
     * @param string $invoiceNr
     * @param string $invoiceDate
     * @param string $event
     * @param string $infoCode
     * @param string $infoText
     */
    public function __construct($changeId = null, $changeDateTime = null, $invoiceNr = null, $invoiceDate = null, $event = null, $infoCode = null, $infoText = null)
    {
        $this
            ->setChangeId($changeId)
            ->setChangeDateTime($changeDateTime)
            ->setInvoiceNr($invoiceNr)
            ->setInvoiceDate($invoiceDate)
            ->setEvent($event)
            ->setInfoCode($infoCode)
            ->setInfoText($infoText);
    }
    /**
     * Get changeId value
     * @return int
     */
    public function getChangeId()
    {
        return $this->changeId;
    }
    /**
     * Set changeId value
     * @param int $changeId
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public function setChangeId($changeId = null)
    {
        // validation for constraint: int
        if (!is_null($changeId) && !is_numeric($changeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($changeId)), __LINE__);
        }
        $this->changeId = $changeId;
        return $this;
    }
    /**
     * Get changeDateTime value
     * @return string
     */
    public function getChangeDateTime()
    {
        return $this->changeDateTime;
    }
    /**
     * Set changeDateTime value
     * @param string $changeDateTime
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public function setChangeDateTime($changeDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($changeDateTime) && !is_string($changeDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($changeDateTime)), __LINE__);
        }
        $this->changeDateTime = $changeDateTime;
        return $this;
    }
    /**
     * Get invoiceNr value
     * @return string
     */
    public function getInvoiceNr()
    {
        return $this->invoiceNr;
    }
    /**
     * Set invoiceNr value
     * @param string $invoiceNr
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public function setInvoiceNr($invoiceNr = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceNr) && strlen($invoiceNr) > 100) || (is_array($invoiceNr) && count($invoiceNr) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceNr) ? strlen($invoiceNr) : count($invoiceNr)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceNr) && !is_string($invoiceNr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceNr)), __LINE__);
        }
        $this->invoiceNr = $invoiceNr;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceDate)), __LINE__);
        }
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get event value
     * @return string
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $event
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public function setEvent($event = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::valueIsValid($event)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $event, implode(', ', \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::getValidValues())), __LINE__);
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Get infoCode value
     * @return string|null
     */
    public function getInfoCode()
    {
        return $this->infoCode;
    }
    /**
     * Set infoCode value
     * @param string $infoCode
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public function setInfoCode($infoCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($infoCode) && strlen($infoCode) > 20) || (is_array($infoCode) && count($infoCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($infoCode) ? strlen($infoCode) : count($infoCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($infoCode) && !is_string($infoCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoCode)), __LINE__);
        }
        $this->infoCode = $infoCode;
        return $this;
    }
    /**
     * Get infoText value
     * @return string|null
     */
    public function getInfoText()
    {
        return $this->infoText;
    }
    /**
     * Set infoText value
     * @param string $infoText
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public function setInfoText($infoText = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($infoText) && strlen($infoText) > 500) || (is_array($infoText) && count($infoText) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($infoText) ? strlen($infoText) : count($infoText)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($infoText) && !is_string($infoText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($infoText)), __LINE__);
        }
        $this->infoText = $infoText;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
