<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleInvoiceBuyStatusResponseType StructType
 * @subpackage Structs
 */
class SaleInvoiceBuyStatusResponseType extends AbstractStructBase
{
    /**
     * The latestChangeId
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $latestChangeId;
    /**
     * The includesLatest
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $includesLatest;
    /**
     * The response
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1000
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType[]
     */
    public $response;
    /**
     * Constructor method for SaleInvoiceBuyStatusResponseType
     * @uses SaleInvoiceBuyStatusResponseType::setLatestChangeId()
     * @uses SaleInvoiceBuyStatusResponseType::setIncludesLatest()
     * @uses SaleInvoiceBuyStatusResponseType::setResponse()
     * @param int $latestChangeId
     * @param string $includesLatest
     * @param \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType[] $response
     */
    public function __construct($latestChangeId = null, $includesLatest = null, array $response = array())
    {
        $this
            ->setLatestChangeId($latestChangeId)
            ->setIncludesLatest($includesLatest)
            ->setResponse($response);
    }
    /**
     * Get latestChangeId value
     * @return int
     */
    public function getLatestChangeId()
    {
        return $this->latestChangeId;
    }
    /**
     * Set latestChangeId value
     * @param int $latestChangeId
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusResponseType
     */
    public function setLatestChangeId($latestChangeId = null)
    {
        // validation for constraint: int
        if (!is_null($latestChangeId) && !is_numeric($latestChangeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($latestChangeId)), __LINE__);
        }
        $this->latestChangeId = $latestChangeId;
        return $this;
    }
    /**
     * Get includesLatest value
     * @return string
     */
    public function getIncludesLatest()
    {
        return $this->includesLatest;
    }
    /**
     * Set includesLatest value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includesLatest
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusResponseType
     */
    public function setIncludesLatest($includesLatest = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($includesLatest)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $includesLatest, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->includesLatest = $includesLatest;
        return $this;
    }
    /**
     * Get response value
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType[]|null
     */
    public function getResponse()
    {
        return $this->response;
    }
    /**
     * Set response value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType[] $response
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusResponseType
     */
    public function setResponse(array $response = array())
    {
        foreach ($response as $saleInvoiceBuyStatusResponseTypeResponseItem) {
            // validation for constraint: itemType
            if (!$saleInvoiceBuyStatusResponseTypeResponseItem instanceof \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType) {
                throw new \InvalidArgumentException(sprintf('The response property can only contain items of \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType, "%s" given', is_object($saleInvoiceBuyStatusResponseTypeResponseItem) ? get_class($saleInvoiceBuyStatusResponseTypeResponseItem) : gettype($saleInvoiceBuyStatusResponseTypeResponseItem)), __LINE__);
            }
        }
        $this->response = $response;
        return $this;
    }
    /**
     * Add item to response value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType $item
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusResponseType
     */
    public function addToResponse(\Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType) {
            throw new \InvalidArgumentException(sprintf('The response property can only contain items of \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->response[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
