<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaleInvoiceBuyStatusRequestType StructType
 * @subpackage Structs
 */
class SaleInvoiceBuyStatusRequestType extends AbstractStructBase
{
    /**
     * The latestChangeId
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $latestChangeId;
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The buyEvent
     * Meta informations extracted from the WSDL
     * - maxOccurs: 10
     * @var string[]
     */
    public $buyEvent;
    /**
     * Constructor method for SaleInvoiceBuyStatusRequestType
     * @uses SaleInvoiceBuyStatusRequestType::setLatestChangeId()
     * @uses SaleInvoiceBuyStatusRequestType::setAuthPhrase()
     * @uses SaleInvoiceBuyStatusRequestType::setBuyEvent()
     * @param int $latestChangeId
     * @param string $authPhrase
     * @param string[] $buyEvent
     */
    public function __construct($latestChangeId = null, $authPhrase = null, array $buyEvent = array())
    {
        $this
            ->setLatestChangeId($latestChangeId)
            ->setAuthPhrase($authPhrase)
            ->setBuyEvent($buyEvent);
    }
    /**
     * Get latestChangeId value
     * @return int
     */
    public function getLatestChangeId()
    {
        return $this->latestChangeId;
    }
    /**
     * Set latestChangeId value
     * @param int $latestChangeId
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType
     */
    public function setLatestChangeId($latestChangeId = null)
    {
        // validation for constraint: int
        if (!is_null($latestChangeId) && !is_numeric($latestChangeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($latestChangeId)), __LINE__);
        }
        $this->latestChangeId = $latestChangeId;
        return $this;
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get buyEvent value
     * @return string[]|null
     */
    public function getBuyEvent()
    {
        return $this->buyEvent;
    }
    /**
     * Set buyEvent value
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $buyEvent
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType
     */
    public function setBuyEvent(array $buyEvent = array())
    {
        $invalidValues = array();
        foreach ($buyEvent as $saleInvoiceBuyStatusRequestTypeBuyEventItem) {
            if (!\Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::valueIsValid($saleInvoiceBuyStatusRequestTypeBuyEventItem)) {
                $invalidValues[] = var_export($saleInvoiceBuyStatusRequestTypeBuyEventItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::getValidValues())), __LINE__);
        }
        $this->buyEvent = $buyEvent;
        return $this;
    }
    /**
     * Add item to buyEvent value
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType
     */
    public function addToBuyEvent($item)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \Lib\OmnivaService\EnumType\BuyInvoiceEventCodeType::getValidValues())), __LINE__);
        }
        $this->buyEvent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
