<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RejectContentType StructType
 * Meta informations extracted from the WSDL
 * - maxLength: 500
 * @subpackage Structs
 */
class RejectContentType extends AbstractStructBase
{
    /**
     * The rejectType
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $rejectType;
    /**
     * The invoiceId
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $invoiceId;
    /**
     * The _
     * Meta informations extracted from the WSDL
     * - maxLength: 500
     * @var string
     */
    public $_;
    /**
     * Constructor method for RejectContentType
     * @uses RejectContentType::setRejectType()
     * @uses RejectContentType::setInvoiceId()
     * @uses RejectContentType::set_()
     * @param string $rejectType
     * @param string $invoiceId
     * @param string $_
     */
    public function __construct($rejectType = null, $invoiceId = null, $_ = null)
    {
        $this
            ->setRejectType($rejectType)
            ->setInvoiceId($invoiceId)
            ->set_($_);
    }
    /**
     * Get rejectType value
     * @return string
     */
    public function getRejectType()
    {
        return $this->rejectType;
    }
    /**
     * Set rejectType value
     * @uses \Lib\OmnivaService\EnumType\RejectTypeType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\RejectTypeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rejectType
     * @return \Lib\OmnivaService\StructType\RejectContentType
     */
    public function setRejectType($rejectType = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\RejectTypeType::valueIsValid($rejectType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $rejectType, implode(', ', \Lib\OmnivaService\EnumType\RejectTypeType::getValidValues())), __LINE__);
        }
        $this->rejectType = $rejectType;
        return $this;
    }
    /**
     * Get invoiceId value
     * @return string
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }
    /**
     * Set invoiceId value
     * @param string $invoiceId
     * @return \Lib\OmnivaService\StructType\RejectContentType
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceId) && strlen($invoiceId) > 100) || (is_array($invoiceId) && count($invoiceId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceId) ? strlen($invoiceId) : count($invoiceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceId)), __LINE__);
        }
        $this->invoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Lib\OmnivaService\StructType\RejectContentType
     */
    public function set_($_ = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($_) && strlen($_) > 500) || (is_array($_) && count($_) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($_) ? strlen($_) : count($_)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($_) && !is_string($_)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($_)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\RejectContentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
