<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RejectConfirmationRequestType StructType
 * @subpackage Structs
 */
class RejectConfirmationRequestType extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Name of the accountant rejecting confirmation
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $name;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - documentation: Reg number of the accountant rejecting confirmation
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $regNumber;
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The RejectContent
     * Meta informations extracted from the WSDL
     * - documentation: Only sale invoices with this state are returned (if any).
     * - maxOccurs: 5
     * @var \Lib\OmnivaService\StructType\RejectContentType[]
     */
    public $RejectContent;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: Country code of the accountant rejecting confirmation
     * - use: optional
     * - maxLength: 100
     * @var string
     */
    public $countryCode;
    /**
     * Constructor method for RejectConfirmationRequestType
     * @uses RejectConfirmationRequestType::setName()
     * @uses RejectConfirmationRequestType::setRegNumber()
     * @uses RejectConfirmationRequestType::setAuthPhrase()
     * @uses RejectConfirmationRequestType::setRejectContent()
     * @uses RejectConfirmationRequestType::setCountryCode()
     * @param string $name
     * @param string $regNumber
     * @param string $authPhrase
     * @param \Lib\OmnivaService\StructType\RejectContentType[] $rejectContent
     * @param string $countryCode
     */
    public function __construct($name = null, $regNumber = null, $authPhrase = null, array $rejectContent = array(), $countryCode = null)
    {
        $this
            ->setName($name)
            ->setRegNumber($regNumber)
            ->setAuthPhrase($authPhrase)
            ->setRejectContent($rejectContent)
            ->setCountryCode($countryCode);
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \Lib\OmnivaService\StructType\RejectConfirmationRequestType
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 100) || (is_array($name) && count($name) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \Lib\OmnivaService\StructType\RejectConfirmationRequestType
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 100) || (is_array($regNumber) && count($regNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\RejectConfirmationRequestType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get RejectContent value
     * @return \Lib\OmnivaService\StructType\RejectContentType[]|null
     */
    public function getRejectContent()
    {
        return $this->RejectContent;
    }
    /**
     * Set RejectContent value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\RejectContentType[] $rejectContent
     * @return \Lib\OmnivaService\StructType\RejectConfirmationRequestType
     */
    public function setRejectContent(array $rejectContent = array())
    {
        foreach ($rejectContent as $rejectConfirmationRequestTypeRejectContentItem) {
            // validation for constraint: itemType
            if (!$rejectConfirmationRequestTypeRejectContentItem instanceof \Lib\OmnivaService\StructType\RejectContentType) {
                throw new \InvalidArgumentException(sprintf('The RejectContent property can only contain items of \Lib\OmnivaService\StructType\RejectContentType, "%s" given', is_object($rejectConfirmationRequestTypeRejectContentItem) ? get_class($rejectConfirmationRequestTypeRejectContentItem) : gettype($rejectConfirmationRequestTypeRejectContentItem)), __LINE__);
            }
        }
        $this->RejectContent = $rejectContent;
        return $this;
    }
    /**
     * Add item to RejectContent value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\RejectContentType $item
     * @return \Lib\OmnivaService\StructType\RejectConfirmationRequestType
     */
    public function addToRejectContent(\Lib\OmnivaService\StructType\RejectContentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\RejectContentType) {
            throw new \InvalidArgumentException(sprintf('The RejectContent property can only contain items of \Lib\OmnivaService\StructType\RejectContentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->RejectContent[] = $item;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Lib\OmnivaService\StructType\RejectConfirmationRequestType
     */
    public function setCountryCode($countryCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($countryCode) && strlen($countryCode) > 100) || (is_array($countryCode) && count($countryCode) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($countryCode) ? strlen($countryCode) : count($countryCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryCode) && !is_string($countryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryCode)), __LINE__);
        }
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\RejectConfirmationRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
