<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Period StructType
 * @subpackage Structs
 */
class Period extends AbstractStructBase
{
    /**
     * The PeriodName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $PeriodName;
    /**
     * The StartDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StartDate;
    /**
     * The EndDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EndDate;
    /**
     * Constructor method for Period
     * @uses Period::setPeriodName()
     * @uses Period::setStartDate()
     * @uses Period::setEndDate()
     * @param string $periodName
     * @param string $startDate
     * @param string $endDate
     */
    public function __construct($periodName = null, $startDate = null, $endDate = null)
    {
        $this
            ->setPeriodName($periodName)
            ->setStartDate($startDate)
            ->setEndDate($endDate);
    }
    /**
     * Get PeriodName value
     * @return string|null
     */
    public function getPeriodName()
    {
        return $this->PeriodName;
    }
    /**
     * Set PeriodName value
     * @param string $periodName
     * @return \Lib\OmnivaService\StructType\Period
     */
    public function setPeriodName($periodName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($periodName) && strlen($periodName) > 100) || (is_array($periodName) && count($periodName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($periodName) ? strlen($periodName) : count($periodName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($periodName) && !is_string($periodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($periodName)), __LINE__);
        }
        $this->PeriodName = $periodName;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \Lib\OmnivaService\StructType\Period
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get EndDate value
     * @return string|null
     */
    public function getEndDate()
    {
        return $this->EndDate;
    }
    /**
     * Set EndDate value
     * @param string $endDate
     * @return \Lib\OmnivaService\StructType\Period
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($endDate)), __LINE__);
        }
        $this->EndDate = $endDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\Period
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
