<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentInfo StructType
 * @subpackage Structs
 */
class PaymentInfo extends AbstractStructBase
{
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - pattern: [A-Z][A-Z][A-Z]
     * @var string
     */
    public $Currency;
    /**
     * The PaymentRefId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * - pattern: ([0-9])*
     * @var string
     */
    public $PaymentRefId;
    /**
     * The PaymentDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 210
     * - pattern: [ -ÿ]*
     * @var string
     */
    public $PaymentDescription;
    /**
     * The Payable
     * @var string
     */
    public $Payable;
    /**
     * The PayDueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PayDueDate;
    /**
     * The PaymentTotalSum
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * @var float
     */
    public $PaymentTotalSum;
    /**
     * The PayerName
     * Meta informations extracted from the WSDL
     * - maxLength: 70
     * - pattern: [ -ÿ]*
     * @var string
     */
    public $PayerName;
    /**
     * The PaymentId
     * @var int
     */
    public $PaymentId;
    /**
     * The PayToAccount
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - pattern: ([0-9|A-Z])*
     * @var string
     */
    public $PayToAccount;
    /**
     * The PayToName
     * Meta informations extracted from the WSDL
     * - maxLength: 70
     * - pattern: [ -ÿ]*
     * @var string
     */
    public $PayToName;
    /**
     * The DirectDebitPayeeContractNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $DirectDebitPayeeContractNumber;
    /**
     * The DirectDebitPayerNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * - pattern: ([0-9])*
     * @var string
     */
    public $DirectDebitPayerNumber;
    /**
     * Constructor method for PaymentInfo
     * @uses PaymentInfo::setCurrency()
     * @uses PaymentInfo::setPaymentRefId()
     * @uses PaymentInfo::setPaymentDescription()
     * @uses PaymentInfo::setPayable()
     * @uses PaymentInfo::setPayDueDate()
     * @uses PaymentInfo::setPaymentTotalSum()
     * @uses PaymentInfo::setPayerName()
     * @uses PaymentInfo::setPaymentId()
     * @uses PaymentInfo::setPayToAccount()
     * @uses PaymentInfo::setPayToName()
     * @uses PaymentInfo::setDirectDebitPayeeContractNumber()
     * @uses PaymentInfo::setDirectDebitPayerNumber()
     * @param string $currency
     * @param string $paymentRefId
     * @param string $paymentDescription
     * @param string $payable
     * @param string $payDueDate
     * @param float $paymentTotalSum
     * @param string $payerName
     * @param int $paymentId
     * @param string $payToAccount
     * @param string $payToName
     * @param string $directDebitPayeeContractNumber
     * @param string $directDebitPayerNumber
     */
    public function __construct($currency = null, $paymentRefId = null, $paymentDescription = null, $payable = null, $payDueDate = null, $paymentTotalSum = null, $payerName = null, $paymentId = null, $payToAccount = null, $payToName = null, $directDebitPayeeContractNumber = null, $directDebitPayerNumber = null)
    {
        $this
            ->setCurrency($currency)
            ->setPaymentRefId($paymentRefId)
            ->setPaymentDescription($paymentDescription)
            ->setPayable($payable)
            ->setPayDueDate($payDueDate)
            ->setPaymentTotalSum($paymentTotalSum)
            ->setPayerName($payerName)
            ->setPaymentId($paymentId)
            ->setPayToAccount($payToAccount)
            ->setPayToName($payToName)
            ->setDirectDebitPayeeContractNumber($directDebitPayeeContractNumber)
            ->setDirectDebitPayerNumber($directDebitPayerNumber);
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($currency) && !preg_match('/[A-Z][A-Z][A-Z]/', $currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z][A-Z][A-Z]", "%s" given', var_export($currency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get PaymentRefId value
     * @return string|null
     */
    public function getPaymentRefId()
    {
        return $this->PaymentRefId;
    }
    /**
     * Set PaymentRefId value
     * @param string $paymentRefId
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPaymentRefId($paymentRefId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentRefId) && strlen($paymentRefId) > 20) || (is_array($paymentRefId) && count($paymentRefId) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($paymentRefId) ? strlen($paymentRefId) : count($paymentRefId)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($paymentRefId) && !preg_match('/([0-9])*/', $paymentRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9])*", "%s" given', var_export($paymentRefId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentRefId) && !is_string($paymentRefId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentRefId)), __LINE__);
        }
        $this->PaymentRefId = $paymentRefId;
        return $this;
    }
    /**
     * Get PaymentDescription value
     * @return string|null
     */
    public function getPaymentDescription()
    {
        return $this->PaymentDescription;
    }
    /**
     * Set PaymentDescription value
     * @param string $paymentDescription
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPaymentDescription($paymentDescription = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($paymentDescription) && strlen($paymentDescription) > 210) || (is_array($paymentDescription) && count($paymentDescription) > 210)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 210 element(s) or a scalar of 210 character(s) at most, "%d" length given', is_scalar($paymentDescription) ? strlen($paymentDescription) : count($paymentDescription)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($paymentDescription) && !preg_match('/[ -ÿ]*/', $paymentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[ -ÿ]*", "%s" given', var_export($paymentDescription, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($paymentDescription) && !is_string($paymentDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentDescription)), __LINE__);
        }
        $this->PaymentDescription = $paymentDescription;
        return $this;
    }
    /**
     * Get Payable value
     * @return string|null
     */
    public function getPayable()
    {
        return $this->Payable;
    }
    /**
     * Set Payable value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $payable
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPayable($payable = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($payable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $payable, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->Payable = $payable;
        return $this;
    }
    /**
     * Get PayDueDate value
     * @return string|null
     */
    public function getPayDueDate()
    {
        return $this->PayDueDate;
    }
    /**
     * Set PayDueDate value
     * @param string $payDueDate
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPayDueDate($payDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDueDate) && !is_string($payDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payDueDate)), __LINE__);
        }
        $this->PayDueDate = $payDueDate;
        return $this;
    }
    /**
     * Get PaymentTotalSum value
     * @return float|null
     */
    public function getPaymentTotalSum()
    {
        return $this->PaymentTotalSum;
    }
    /**
     * Set PaymentTotalSum value
     * @param float $paymentTotalSum
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPaymentTotalSum($paymentTotalSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($paymentTotalSum) && strlen(substr($paymentTotalSum, strpos($paymentTotalSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($paymentTotalSum, strpos($paymentTotalSum, '.') + 1))), __LINE__);
        }
        $this->PaymentTotalSum = $paymentTotalSum;
        return $this;
    }
    /**
     * Get PayerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->PayerName;
    }
    /**
     * Set PayerName value
     * @param string $payerName
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($payerName) && strlen($payerName) > 70) || (is_array($payerName) && count($payerName) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($payerName) ? strlen($payerName) : count($payerName)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($payerName) && !preg_match('/[ -ÿ]*/', $payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[ -ÿ]*", "%s" given', var_export($payerName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payerName)), __LINE__);
        }
        $this->PayerName = $payerName;
        return $this;
    }
    /**
     * Get PaymentId value
     * @return int|null
     */
    public function getPaymentId()
    {
        return $this->PaymentId;
    }
    /**
     * Set PaymentId value
     * @param int $paymentId
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPaymentId($paymentId = null)
    {
        // validation for constraint: int
        if (!is_null($paymentId) && !is_numeric($paymentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentId)), __LINE__);
        }
        $this->PaymentId = $paymentId;
        return $this;
    }
    /**
     * Get PayToAccount value
     * @return string|null
     */
    public function getPayToAccount()
    {
        return $this->PayToAccount;
    }
    /**
     * Set PayToAccount value
     * @param string $payToAccount
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPayToAccount($payToAccount = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($payToAccount) && strlen($payToAccount) > 35) || (is_array($payToAccount) && count($payToAccount) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($payToAccount) ? strlen($payToAccount) : count($payToAccount)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($payToAccount) && !preg_match('/([0-9|A-Z])*/', $payToAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9|A-Z])*", "%s" given', var_export($payToAccount, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($payToAccount) && !is_string($payToAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payToAccount)), __LINE__);
        }
        $this->PayToAccount = $payToAccount;
        return $this;
    }
    /**
     * Get PayToName value
     * @return string|null
     */
    public function getPayToName()
    {
        return $this->PayToName;
    }
    /**
     * Set PayToName value
     * @param string $payToName
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setPayToName($payToName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($payToName) && strlen($payToName) > 70) || (is_array($payToName) && count($payToName) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($payToName) ? strlen($payToName) : count($payToName)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($payToName) && !preg_match('/[ -ÿ]*/', $payToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[ -ÿ]*", "%s" given', var_export($payToName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($payToName) && !is_string($payToName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($payToName)), __LINE__);
        }
        $this->PayToName = $payToName;
        return $this;
    }
    /**
     * Get DirectDebitPayeeContractNumber value
     * @return string|null
     */
    public function getDirectDebitPayeeContractNumber()
    {
        return $this->DirectDebitPayeeContractNumber;
    }
    /**
     * Set DirectDebitPayeeContractNumber value
     * @param string $directDebitPayeeContractNumber
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setDirectDebitPayeeContractNumber($directDebitPayeeContractNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($directDebitPayeeContractNumber) && strlen($directDebitPayeeContractNumber) > 20) || (is_array($directDebitPayeeContractNumber) && count($directDebitPayeeContractNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($directDebitPayeeContractNumber) ? strlen($directDebitPayeeContractNumber) : count($directDebitPayeeContractNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directDebitPayeeContractNumber) && !is_string($directDebitPayeeContractNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directDebitPayeeContractNumber)), __LINE__);
        }
        $this->DirectDebitPayeeContractNumber = $directDebitPayeeContractNumber;
        return $this;
    }
    /**
     * Get DirectDebitPayerNumber value
     * @return string|null
     */
    public function getDirectDebitPayerNumber()
    {
        return $this->DirectDebitPayerNumber;
    }
    /**
     * Set DirectDebitPayerNumber value
     * @param string $directDebitPayerNumber
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public function setDirectDebitPayerNumber($directDebitPayerNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($directDebitPayerNumber) && strlen($directDebitPayerNumber) > 20) || (is_array($directDebitPayerNumber) && count($directDebitPayerNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($directDebitPayerNumber) ? strlen($directDebitPayerNumber) : count($directDebitPayerNumber)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($directDebitPayerNumber) && !preg_match('/([0-9])*/', $directDebitPayerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9])*", "%s" given', var_export($directDebitPayerNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($directDebitPayerNumber) && !is_string($directDebitPayerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($directDebitPayerNumber)), __LINE__);
        }
        $this->DirectDebitPayerNumber = $directDebitPayerNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\PaymentInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
