<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JournalEntry StructType
 * @subpackage Structs
 */
class JournalEntry extends AbstractStructBase
{
    /**
     * The GeneralLedger
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $GeneralLedger;
    /**
     * The GeneralLedgerDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $GeneralLedgerDetail;
    /**
     * The CostObjective
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $CostObjective;
    /**
     * The Sum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $Sum;
    /**
     * The VatSum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $VatSum;
    /**
     * The VatRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 2
     * @var float
     */
    public $VatRate;
    /**
     * Constructor method for JournalEntry
     * @uses JournalEntry::setGeneralLedger()
     * @uses JournalEntry::setGeneralLedgerDetail()
     * @uses JournalEntry::setCostObjective()
     * @uses JournalEntry::setSum()
     * @uses JournalEntry::setVatSum()
     * @uses JournalEntry::setVatRate()
     * @param string $generalLedger
     * @param string $generalLedgerDetail
     * @param string $costObjective
     * @param float $sum
     * @param float $vatSum
     * @param float $vatRate
     */
    public function __construct($generalLedger = null, $generalLedgerDetail = null, $costObjective = null, $sum = null, $vatSum = null, $vatRate = null)
    {
        $this
            ->setGeneralLedger($generalLedger)
            ->setGeneralLedgerDetail($generalLedgerDetail)
            ->setCostObjective($costObjective)
            ->setSum($sum)
            ->setVatSum($vatSum)
            ->setVatRate($vatRate);
    }
    /**
     * Get GeneralLedger value
     * @return string|null
     */
    public function getGeneralLedger()
    {
        return $this->GeneralLedger;
    }
    /**
     * Set GeneralLedger value
     * @param string $generalLedger
     * @return \Lib\OmnivaService\StructType\JournalEntry
     */
    public function setGeneralLedger($generalLedger = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($generalLedger) && strlen($generalLedger) > 20) || (is_array($generalLedger) && count($generalLedger) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($generalLedger) ? strlen($generalLedger) : count($generalLedger)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($generalLedger) && !is_string($generalLedger)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($generalLedger)), __LINE__);
        }
        $this->GeneralLedger = $generalLedger;
        return $this;
    }
    /**
     * Get GeneralLedgerDetail value
     * @return string|null
     */
    public function getGeneralLedgerDetail()
    {
        return $this->GeneralLedgerDetail;
    }
    /**
     * Set GeneralLedgerDetail value
     * @param string $generalLedgerDetail
     * @return \Lib\OmnivaService\StructType\JournalEntry
     */
    public function setGeneralLedgerDetail($generalLedgerDetail = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($generalLedgerDetail) && strlen($generalLedgerDetail) > 20) || (is_array($generalLedgerDetail) && count($generalLedgerDetail) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($generalLedgerDetail) ? strlen($generalLedgerDetail) : count($generalLedgerDetail)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($generalLedgerDetail) && !is_string($generalLedgerDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($generalLedgerDetail)), __LINE__);
        }
        $this->GeneralLedgerDetail = $generalLedgerDetail;
        return $this;
    }
    /**
     * Get CostObjective value
     * @return string|null
     */
    public function getCostObjective()
    {
        return $this->CostObjective;
    }
    /**
     * Set CostObjective value
     * @param string $costObjective
     * @return \Lib\OmnivaService\StructType\JournalEntry
     */
    public function setCostObjective($costObjective = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($costObjective) && strlen($costObjective) > 20) || (is_array($costObjective) && count($costObjective) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($costObjective) ? strlen($costObjective) : count($costObjective)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($costObjective) && !is_string($costObjective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($costObjective)), __LINE__);
        }
        $this->CostObjective = $costObjective;
        return $this;
    }
    /**
     * Get Sum value
     * @return float|null
     */
    public function getSum()
    {
        return $this->Sum;
    }
    /**
     * Set Sum value
     * @param float $sum
     * @return \Lib\OmnivaService\StructType\JournalEntry
     */
    public function setSum($sum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($sum) && strlen(substr($sum, strpos($sum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($sum, strpos($sum, '.') + 1))), __LINE__);
        }
        $this->Sum = $sum;
        return $this;
    }
    /**
     * Get VatSum value
     * @return float|null
     */
    public function getVatSum()
    {
        return $this->VatSum;
    }
    /**
     * Set VatSum value
     * @param float $vatSum
     * @return \Lib\OmnivaService\StructType\JournalEntry
     */
    public function setVatSum($vatSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($vatSum) && strlen(substr($vatSum, strpos($vatSum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($vatSum, strpos($vatSum, '.') + 1))), __LINE__);
        }
        $this->VatSum = $vatSum;
        return $this;
    }
    /**
     * Get VatRate value
     * @return float|null
     */
    public function getVatRate()
    {
        return $this->VatRate;
    }
    /**
     * Set VatRate value
     * @param float $vatRate
     * @return \Lib\OmnivaService\StructType\JournalEntry
     */
    public function setVatRate($vatRate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($vatRate) && strlen(substr($vatRate, strpos($vatRate, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($vatRate, strpos($vatRate, '.') + 1))), __LINE__);
        }
        $this->VatRate = $vatRate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\JournalEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
