<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ItemEntry StructType
 * @subpackage Structs
 */
class ItemEntry extends AbstractStructBase
{
    /**
     * The SerialNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $SerialNumber;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $Code;
    /**
     * The Accounting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AccountingRecord
     */
    public $Accounting;
    /**
     * The CustomerRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $CustomerRef;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxLength: 500
     * @var string
     */
    public $Description;
    /**
     * The EAN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $EAN;
    /**
     * The InitialReading
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $InitialReading;
    /**
     * The FinalReading
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $FinalReading;
    /**
     * The ItemReserve
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $ItemReserve;
    /**
     * The ItemUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $ItemUnit;
    /**
     * The ItemAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $ItemAmount;
    /**
     * The ItemPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $ItemPrice;
    /**
     * The ItemSum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $ItemSum;
    /**
     * The Addition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AdditionRecord[]
     */
    public $Addition;
    /**
     * The VAT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\VATRecord
     */
    public $VAT;
    /**
     * The ItemTotal
     * Meta informations extracted from the WSDL
     * - fractionDigits: 4
     * @var float
     */
    public $ItemTotal;
    /**
     * Constructor method for ItemEntry
     * @uses ItemEntry::setSerialNumber()
     * @uses ItemEntry::setCode()
     * @uses ItemEntry::setAccounting()
     * @uses ItemEntry::setCustomerRef()
     * @uses ItemEntry::setDescription()
     * @uses ItemEntry::setEAN()
     * @uses ItemEntry::setInitialReading()
     * @uses ItemEntry::setFinalReading()
     * @uses ItemEntry::setItemReserve()
     * @uses ItemEntry::setItemUnit()
     * @uses ItemEntry::setItemAmount()
     * @uses ItemEntry::setItemPrice()
     * @uses ItemEntry::setItemSum()
     * @uses ItemEntry::setAddition()
     * @uses ItemEntry::setVAT()
     * @uses ItemEntry::setItemTotal()
     * @param string $serialNumber
     * @param string $code
     * @param \Lib\OmnivaService\StructType\AccountingRecord $accounting
     * @param string $customerRef
     * @param string $description
     * @param string $eAN
     * @param string $initialReading
     * @param string $finalReading
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $itemReserve
     * @param string $itemUnit
     * @param float $itemAmount
     * @param float $itemPrice
     * @param float $itemSum
     * @param \Lib\OmnivaService\StructType\AdditionRecord[] $addition
     * @param \Lib\OmnivaService\StructType\VATRecord $vAT
     * @param float $itemTotal
     */
    public function __construct($serialNumber = null, $code = null, \Lib\OmnivaService\StructType\AccountingRecord $accounting = null, $customerRef = null, $description = null, $eAN = null, $initialReading = null, $finalReading = null, array $itemReserve = array(), $itemUnit = null, $itemAmount = null, $itemPrice = null, $itemSum = null, array $addition = array(), \Lib\OmnivaService\StructType\VATRecord $vAT = null, $itemTotal = null)
    {
        $this
            ->setSerialNumber($serialNumber)
            ->setCode($code)
            ->setAccounting($accounting)
            ->setCustomerRef($customerRef)
            ->setDescription($description)
            ->setEAN($eAN)
            ->setInitialReading($initialReading)
            ->setFinalReading($finalReading)
            ->setItemReserve($itemReserve)
            ->setItemUnit($itemUnit)
            ->setItemAmount($itemAmount)
            ->setItemPrice($itemPrice)
            ->setItemSum($itemSum)
            ->setAddition($addition)
            ->setVAT($vAT)
            ->setItemTotal($itemTotal);
    }
    /**
     * Get SerialNumber value
     * @return string|null
     */
    public function getSerialNumber()
    {
        return $this->SerialNumber;
    }
    /**
     * Set SerialNumber value
     * @param string $serialNumber
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setSerialNumber($serialNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serialNumber) && strlen($serialNumber) > 20) || (is_array($serialNumber) && count($serialNumber) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($serialNumber) ? strlen($serialNumber) : count($serialNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serialNumber) && !is_string($serialNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serialNumber)), __LINE__);
        }
        $this->SerialNumber = $serialNumber;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 20) || (is_array($code) && count($code) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Accounting value
     * @return \Lib\OmnivaService\StructType\AccountingRecord|null
     */
    public function getAccounting()
    {
        return $this->Accounting;
    }
    /**
     * Set Accounting value
     * @param \Lib\OmnivaService\StructType\AccountingRecord $accounting
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setAccounting(\Lib\OmnivaService\StructType\AccountingRecord $accounting = null)
    {
        $this->Accounting = $accounting;
        return $this;
    }
    /**
     * Get CustomerRef value
     * @return string|null
     */
    public function getCustomerRef()
    {
        return $this->CustomerRef;
    }
    /**
     * Set CustomerRef value
     * @param string $customerRef
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setCustomerRef($customerRef = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($customerRef) && strlen($customerRef) > 100) || (is_array($customerRef) && count($customerRef) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($customerRef) ? strlen($customerRef) : count($customerRef)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($customerRef) && !is_string($customerRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($customerRef)), __LINE__);
        }
        $this->CustomerRef = $customerRef;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 500) || (is_array($description) && count($description) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get EAN value
     * @return string|null
     */
    public function getEAN()
    {
        return $this->EAN;
    }
    /**
     * Set EAN value
     * @param string $eAN
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setEAN($eAN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($eAN) && strlen($eAN) > 100) || (is_array($eAN) && count($eAN) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($eAN) ? strlen($eAN) : count($eAN)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($eAN) && !is_string($eAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eAN)), __LINE__);
        }
        $this->EAN = $eAN;
        return $this;
    }
    /**
     * Get InitialReading value
     * @return string|null
     */
    public function getInitialReading()
    {
        return $this->InitialReading;
    }
    /**
     * Set InitialReading value
     * @param string $initialReading
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setInitialReading($initialReading = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($initialReading) && strlen($initialReading) > 20) || (is_array($initialReading) && count($initialReading) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($initialReading) ? strlen($initialReading) : count($initialReading)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($initialReading) && !is_string($initialReading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($initialReading)), __LINE__);
        }
        $this->InitialReading = $initialReading;
        return $this;
    }
    /**
     * Get FinalReading value
     * @return string|null
     */
    public function getFinalReading()
    {
        return $this->FinalReading;
    }
    /**
     * Set FinalReading value
     * @param string $finalReading
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setFinalReading($finalReading = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($finalReading) && strlen($finalReading) > 20) || (is_array($finalReading) && count($finalReading) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($finalReading) ? strlen($finalReading) : count($finalReading)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($finalReading) && !is_string($finalReading)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($finalReading)), __LINE__);
        }
        $this->FinalReading = $finalReading;
        return $this;
    }
    /**
     * Get ItemReserve value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getItemReserve()
    {
        return $this->ItemReserve;
    }
    /**
     * Set ItemReserve value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $itemReserve
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setItemReserve(array $itemReserve = array())
    {
        foreach ($itemReserve as $itemEntryItemReserveItem) {
            // validation for constraint: itemType
            if (!$itemEntryItemReserveItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The ItemReserve property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($itemEntryItemReserveItem) ? get_class($itemEntryItemReserveItem) : gettype($itemEntryItemReserveItem)), __LINE__);
            }
        }
        $this->ItemReserve = $itemReserve;
        return $this;
    }
    /**
     * Add item to ItemReserve value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function addToItemReserve(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The ItemReserve property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemReserve[] = $item;
        return $this;
    }
    /**
     * Get ItemUnit value
     * @return string|null
     */
    public function getItemUnit()
    {
        return $this->ItemUnit;
    }
    /**
     * Set ItemUnit value
     * @param string $itemUnit
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setItemUnit($itemUnit = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($itemUnit) && strlen($itemUnit) > 20) || (is_array($itemUnit) && count($itemUnit) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($itemUnit) ? strlen($itemUnit) : count($itemUnit)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($itemUnit) && !is_string($itemUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemUnit)), __LINE__);
        }
        $this->ItemUnit = $itemUnit;
        return $this;
    }
    /**
     * Get ItemAmount value
     * @return float|null
     */
    public function getItemAmount()
    {
        return $this->ItemAmount;
    }
    /**
     * Set ItemAmount value
     * @param float $itemAmount
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setItemAmount($itemAmount = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($itemAmount) && strlen(substr($itemAmount, strpos($itemAmount, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($itemAmount, strpos($itemAmount, '.') + 1))), __LINE__);
        }
        $this->ItemAmount = $itemAmount;
        return $this;
    }
    /**
     * Get ItemPrice value
     * @return float|null
     */
    public function getItemPrice()
    {
        return $this->ItemPrice;
    }
    /**
     * Set ItemPrice value
     * @param float $itemPrice
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setItemPrice($itemPrice = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($itemPrice) && strlen(substr($itemPrice, strpos($itemPrice, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($itemPrice, strpos($itemPrice, '.') + 1))), __LINE__);
        }
        $this->ItemPrice = $itemPrice;
        return $this;
    }
    /**
     * Get ItemSum value
     * @return float|null
     */
    public function getItemSum()
    {
        return $this->ItemSum;
    }
    /**
     * Set ItemSum value
     * @param float $itemSum
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setItemSum($itemSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($itemSum) && strlen(substr($itemSum, strpos($itemSum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($itemSum, strpos($itemSum, '.') + 1))), __LINE__);
        }
        $this->ItemSum = $itemSum;
        return $this;
    }
    /**
     * Get Addition value
     * @return \Lib\OmnivaService\StructType\AdditionRecord[]|null
     */
    public function getAddition()
    {
        return $this->Addition;
    }
    /**
     * Set Addition value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AdditionRecord[] $addition
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setAddition(array $addition = array())
    {
        foreach ($addition as $itemEntryAdditionItem) {
            // validation for constraint: itemType
            if (!$itemEntryAdditionItem instanceof \Lib\OmnivaService\StructType\AdditionRecord) {
                throw new \InvalidArgumentException(sprintf('The Addition property can only contain items of \Lib\OmnivaService\StructType\AdditionRecord, "%s" given', is_object($itemEntryAdditionItem) ? get_class($itemEntryAdditionItem) : gettype($itemEntryAdditionItem)), __LINE__);
            }
        }
        $this->Addition = $addition;
        return $this;
    }
    /**
     * Add item to Addition value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AdditionRecord $item
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function addToAddition(\Lib\OmnivaService\StructType\AdditionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\AdditionRecord) {
            throw new \InvalidArgumentException(sprintf('The Addition property can only contain items of \Lib\OmnivaService\StructType\AdditionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Addition[] = $item;
        return $this;
    }
    /**
     * Get VAT value
     * @return \Lib\OmnivaService\StructType\VATRecord|null
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @param \Lib\OmnivaService\StructType\VATRecord $vAT
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setVAT(\Lib\OmnivaService\StructType\VATRecord $vAT = null)
    {
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Get ItemTotal value
     * @return float|null
     */
    public function getItemTotal()
    {
        return $this->ItemTotal;
    }
    /**
     * Set ItemTotal value
     * @param float $itemTotal
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public function setItemTotal($itemTotal = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($itemTotal) && strlen(substr($itemTotal, strpos($itemTotal, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($itemTotal, strpos($itemTotal, '.') + 1))), __LINE__);
        }
        $this->ItemTotal = $itemTotal;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\ItemEntry
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
