<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceSumGroup StructType
 * @subpackage Structs
 */
class InvoiceSumGroup extends AbstractStructBase
{
    /**
     * The Balance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\Balance
     */
    public $Balance;
    /**
     * The InvoiceSum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $InvoiceSum;
    /**
     * The PenaltySum
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $PenaltySum;
    /**
     * The Addition
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AdditionRecord[]
     */
    public $Addition;
    /**
     * The Rounding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 4
     * @var float
     */
    public $Rounding;
    /**
     * The VAT
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\VATRecord[]
     */
    public $VAT;
    /**
     * The TotalSum
     * Meta informations extracted from the WSDL
     * - fractionDigits: 2
     * @var float
     */
    public $TotalSum;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - pattern: [A-Z][A-Z][A-Z]
     * @var string
     */
    public $Currency;
    /**
     * The Accounting
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AccountingRecord
     */
    public $Accounting;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $Extension;
    /**
     * Constructor method for InvoiceSumGroup
     * @uses InvoiceSumGroup::setBalance()
     * @uses InvoiceSumGroup::setInvoiceSum()
     * @uses InvoiceSumGroup::setPenaltySum()
     * @uses InvoiceSumGroup::setAddition()
     * @uses InvoiceSumGroup::setRounding()
     * @uses InvoiceSumGroup::setVAT()
     * @uses InvoiceSumGroup::setTotalSum()
     * @uses InvoiceSumGroup::setCurrency()
     * @uses InvoiceSumGroup::setAccounting()
     * @uses InvoiceSumGroup::setExtension()
     * @param \Lib\OmnivaService\StructType\Balance $balance
     * @param float $invoiceSum
     * @param float $penaltySum
     * @param \Lib\OmnivaService\StructType\AdditionRecord[] $addition
     * @param float $rounding
     * @param \Lib\OmnivaService\StructType\VATRecord[] $vAT
     * @param float $totalSum
     * @param string $currency
     * @param \Lib\OmnivaService\StructType\AccountingRecord $accounting
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     */
    public function __construct(\Lib\OmnivaService\StructType\Balance $balance = null, $invoiceSum = null, $penaltySum = null, array $addition = array(), $rounding = null, array $vAT = array(), $totalSum = null, $currency = null, \Lib\OmnivaService\StructType\AccountingRecord $accounting = null, array $extension = array())
    {
        $this
            ->setBalance($balance)
            ->setInvoiceSum($invoiceSum)
            ->setPenaltySum($penaltySum)
            ->setAddition($addition)
            ->setRounding($rounding)
            ->setVAT($vAT)
            ->setTotalSum($totalSum)
            ->setCurrency($currency)
            ->setAccounting($accounting)
            ->setExtension($extension);
    }
    /**
     * Get Balance value
     * @return \Lib\OmnivaService\StructType\Balance|null
     */
    public function getBalance()
    {
        return $this->Balance;
    }
    /**
     * Set Balance value
     * @param \Lib\OmnivaService\StructType\Balance $balance
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setBalance(\Lib\OmnivaService\StructType\Balance $balance = null)
    {
        $this->Balance = $balance;
        return $this;
    }
    /**
     * Get InvoiceSum value
     * @return float|null
     */
    public function getInvoiceSum()
    {
        return $this->InvoiceSum;
    }
    /**
     * Set InvoiceSum value
     * @param float $invoiceSum
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setInvoiceSum($invoiceSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($invoiceSum) && strlen(substr($invoiceSum, strpos($invoiceSum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($invoiceSum, strpos($invoiceSum, '.') + 1))), __LINE__);
        }
        $this->InvoiceSum = $invoiceSum;
        return $this;
    }
    /**
     * Get PenaltySum value
     * @return float|null
     */
    public function getPenaltySum()
    {
        return $this->PenaltySum;
    }
    /**
     * Set PenaltySum value
     * @param float $penaltySum
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setPenaltySum($penaltySum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($penaltySum) && strlen(substr($penaltySum, strpos($penaltySum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($penaltySum, strpos($penaltySum, '.') + 1))), __LINE__);
        }
        $this->PenaltySum = $penaltySum;
        return $this;
    }
    /**
     * Get Addition value
     * @return \Lib\OmnivaService\StructType\AdditionRecord[]|null
     */
    public function getAddition()
    {
        return $this->Addition;
    }
    /**
     * Set Addition value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AdditionRecord[] $addition
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setAddition(array $addition = array())
    {
        foreach ($addition as $invoiceSumGroupAdditionItem) {
            // validation for constraint: itemType
            if (!$invoiceSumGroupAdditionItem instanceof \Lib\OmnivaService\StructType\AdditionRecord) {
                throw new \InvalidArgumentException(sprintf('The Addition property can only contain items of \Lib\OmnivaService\StructType\AdditionRecord, "%s" given', is_object($invoiceSumGroupAdditionItem) ? get_class($invoiceSumGroupAdditionItem) : gettype($invoiceSumGroupAdditionItem)), __LINE__);
            }
        }
        $this->Addition = $addition;
        return $this;
    }
    /**
     * Add item to Addition value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AdditionRecord $item
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function addToAddition(\Lib\OmnivaService\StructType\AdditionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\AdditionRecord) {
            throw new \InvalidArgumentException(sprintf('The Addition property can only contain items of \Lib\OmnivaService\StructType\AdditionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Addition[] = $item;
        return $this;
    }
    /**
     * Get Rounding value
     * @return float|null
     */
    public function getRounding()
    {
        return $this->Rounding;
    }
    /**
     * Set Rounding value
     * @param float $rounding
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setRounding($rounding = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($rounding) && strlen(substr($rounding, strpos($rounding, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($rounding, strpos($rounding, '.') + 1))), __LINE__);
        }
        $this->Rounding = $rounding;
        return $this;
    }
    /**
     * Get VAT value
     * @return \Lib\OmnivaService\StructType\VATRecord[]|null
     */
    public function getVAT()
    {
        return $this->VAT;
    }
    /**
     * Set VAT value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\VATRecord[] $vAT
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setVAT(array $vAT = array())
    {
        foreach ($vAT as $invoiceSumGroupVATItem) {
            // validation for constraint: itemType
            if (!$invoiceSumGroupVATItem instanceof \Lib\OmnivaService\StructType\VATRecord) {
                throw new \InvalidArgumentException(sprintf('The VAT property can only contain items of \Lib\OmnivaService\StructType\VATRecord, "%s" given', is_object($invoiceSumGroupVATItem) ? get_class($invoiceSumGroupVATItem) : gettype($invoiceSumGroupVATItem)), __LINE__);
            }
        }
        $this->VAT = $vAT;
        return $this;
    }
    /**
     * Add item to VAT value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\VATRecord $item
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function addToVAT(\Lib\OmnivaService\StructType\VATRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\VATRecord) {
            throw new \InvalidArgumentException(sprintf('The VAT property can only contain items of \Lib\OmnivaService\StructType\VATRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VAT[] = $item;
        return $this;
    }
    /**
     * Get TotalSum value
     * @return float|null
     */
    public function getTotalSum()
    {
        return $this->TotalSum;
    }
    /**
     * Set TotalSum value
     * @param float $totalSum
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setTotalSum($totalSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($totalSum) && strlen(substr($totalSum, strpos($totalSum, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($totalSum, strpos($totalSum, '.') + 1))), __LINE__);
        }
        $this->TotalSum = $totalSum;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: pattern
        if (is_scalar($currency) && !preg_match('/[A-Z][A-Z][A-Z]/', $currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[A-Z][A-Z][A-Z]", "%s" given', var_export($currency, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get Accounting value
     * @return \Lib\OmnivaService\StructType\AccountingRecord|null
     */
    public function getAccounting()
    {
        return $this->Accounting;
    }
    /**
     * Set Accounting value
     * @param \Lib\OmnivaService\StructType\AccountingRecord $accounting
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setAccounting(\Lib\OmnivaService\StructType\AccountingRecord $accounting = null)
    {
        $this->Accounting = $accounting;
        return $this;
    }
    /**
     * Get Extension value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function setExtension(array $extension = array())
    {
        foreach ($extension as $invoiceSumGroupExtensionItem) {
            // validation for constraint: itemType
            if (!$invoiceSumGroupExtensionItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($invoiceSumGroupExtensionItem) ? get_class($invoiceSumGroupExtensionItem) : gettype($invoiceSumGroupExtensionItem)), __LINE__);
            }
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Add item to Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public function addToExtension(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
