<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceAttachmentRequestType StructType
 * @subpackage Structs
 */
class InvoiceAttachmentRequestType extends AbstractStructBase
{
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The startIndex
     * Meta informations extracted from the WSDL
     * - documentation: inclusive index of attachment. Can be used if more than maximum result set returned. Minimum 1
     * - use: required
     * @var int
     */
    public $startIndex;
    /**
     * The invoiceId
     * Meta informations extracted from the WSDL
     * - documentation: InvoiceId for attachments
     * - maxLength: 100
     * @var string
     */
    public $invoiceId;
    /**
     * The onlyInvoice
     * Meta informations extracted from the WSDL
     * - documentation: If yes only invoice main attachment is returned
     * - use: optional
     * @var string
     */
    public $onlyInvoice;
    /**
     * The operator
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $operator;
    /**
     * Constructor method for InvoiceAttachmentRequestType
     * @uses InvoiceAttachmentRequestType::setAuthPhrase()
     * @uses InvoiceAttachmentRequestType::setStartIndex()
     * @uses InvoiceAttachmentRequestType::setInvoiceId()
     * @uses InvoiceAttachmentRequestType::setOnlyInvoice()
     * @uses InvoiceAttachmentRequestType::setOperator()
     * @param string $authPhrase
     * @param int $startIndex
     * @param string $invoiceId
     * @param string $onlyInvoice
     * @param string $operator
     */
    public function __construct($authPhrase = null, $startIndex = null, $invoiceId = null, $onlyInvoice = null, $operator = null)
    {
        $this
            ->setAuthPhrase($authPhrase)
            ->setStartIndex($startIndex)
            ->setInvoiceId($invoiceId)
            ->setOnlyInvoice($onlyInvoice)
            ->setOperator($operator);
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get startIndex value
     * @return int
     */
    public function getStartIndex()
    {
        return $this->startIndex;
    }
    /**
     * Set startIndex value
     * @param int $startIndex
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType
     */
    public function setStartIndex($startIndex = null)
    {
        // validation for constraint: int
        if (!is_null($startIndex) && !is_numeric($startIndex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($startIndex)), __LINE__);
        }
        $this->startIndex = $startIndex;
        return $this;
    }
    /**
     * Get invoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }
    /**
     * Set invoiceId value
     * @param string $invoiceId
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceId) && strlen($invoiceId) > 100) || (is_array($invoiceId) && count($invoiceId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceId) ? strlen($invoiceId) : count($invoiceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceId)), __LINE__);
        }
        $this->invoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get onlyInvoice value
     * @return string|null
     */
    public function getOnlyInvoice()
    {
        return $this->onlyInvoice;
    }
    /**
     * Set onlyInvoice value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $onlyInvoice
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType
     */
    public function setOnlyInvoice($onlyInvoice = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($onlyInvoice)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $onlyInvoice, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->onlyInvoice = $onlyInvoice;
        return $this;
    }
    /**
     * Get operator value
     * @return string|null
     */
    public function getOperator()
    {
        return $this->operator;
    }
    /**
     * Set operator value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operator
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType
     */
    public function setOperator($operator = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($operator)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $operator, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->operator = $operator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
