<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Invoice StructType
 * @subpackage Structs
 */
class Invoice extends AbstractStructBase
{
    /**
     * The invoiceId
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 100
     * @var string
     */
    public $invoiceId;
    /**
     * The serviceId
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 20
     * @var string
     */
    public $serviceId;
    /**
     * The regNumber
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 15
     * @var string
     */
    public $regNumber;
    /**
     * The accountNumber
     * Meta informations extracted from the WSDL
     * - use: required
     * - maxLength: 35
     * - pattern: ([0-9|A-Z])*
     * @var string
     */
    public $accountNumber;
    /**
     * The InvoiceParties
     * Meta informations extracted from the WSDL
     * - ref: InvoiceParties
     * @var \Lib\OmnivaService\StructType\InvoiceParties
     */
    public $InvoiceParties;
    /**
     * The InvoiceInformation
     * Meta informations extracted from the WSDL
     * - ref: InvoiceInformation
     * @var \Lib\OmnivaService\StructType\InvoiceInformation
     */
    public $InvoiceInformation;
    /**
     * The InvoiceSumGroup
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - ref: InvoiceSumGroup
     * @var \Lib\OmnivaService\StructType\InvoiceSumGroup[]
     */
    public $InvoiceSumGroup;
    /**
     * The InvoiceItem
     * Meta informations extracted from the WSDL
     * - ref: InvoiceItem
     * @var \Lib\OmnivaService\StructType\InvoiceItem
     */
    public $InvoiceItem;
    /**
     * The AdditionalInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: AdditionalInformation
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $AdditionalInformation;
    /**
     * The PaymentInfo
     * Meta informations extracted from the WSDL
     * - ref: PaymentInfo
     * @var \Lib\OmnivaService\StructType\PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The factoring
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $factoring;
    /**
     * Constructor method for Invoice
     * @uses Invoice::setInvoiceId()
     * @uses Invoice::setServiceId()
     * @uses Invoice::setRegNumber()
     * @uses Invoice::setAccountNumber()
     * @uses Invoice::setInvoiceParties()
     * @uses Invoice::setInvoiceInformation()
     * @uses Invoice::setInvoiceSumGroup()
     * @uses Invoice::setInvoiceItem()
     * @uses Invoice::setAdditionalInformation()
     * @uses Invoice::setPaymentInfo()
     * @uses Invoice::setFactoring()
     * @param string $invoiceId
     * @param string $serviceId
     * @param string $regNumber
     * @param string $accountNumber
     * @param \Lib\OmnivaService\StructType\InvoiceParties $invoiceParties
     * @param \Lib\OmnivaService\StructType\InvoiceInformation $invoiceInformation
     * @param \Lib\OmnivaService\StructType\InvoiceSumGroup[] $invoiceSumGroup
     * @param \Lib\OmnivaService\StructType\InvoiceItem $invoiceItem
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $additionalInformation
     * @param \Lib\OmnivaService\StructType\PaymentInfo $paymentInfo
     * @param string $factoring
     */
    public function __construct($invoiceId = null, $serviceId = null, $regNumber = null, $accountNumber = null, \Lib\OmnivaService\StructType\InvoiceParties $invoiceParties = null, \Lib\OmnivaService\StructType\InvoiceInformation $invoiceInformation = null, array $invoiceSumGroup = array(), \Lib\OmnivaService\StructType\InvoiceItem $invoiceItem = null, array $additionalInformation = array(), \Lib\OmnivaService\StructType\PaymentInfo $paymentInfo = null, $factoring = null)
    {
        $this
            ->setInvoiceId($invoiceId)
            ->setServiceId($serviceId)
            ->setRegNumber($regNumber)
            ->setAccountNumber($accountNumber)
            ->setInvoiceParties($invoiceParties)
            ->setInvoiceInformation($invoiceInformation)
            ->setInvoiceSumGroup($invoiceSumGroup)
            ->setInvoiceItem($invoiceItem)
            ->setAdditionalInformation($additionalInformation)
            ->setPaymentInfo($paymentInfo)
            ->setFactoring($factoring);
    }
    /**
     * Get invoiceId value
     * @return string
     */
    public function getInvoiceId()
    {
        return $this->invoiceId;
    }
    /**
     * Set invoiceId value
     * @param string $invoiceId
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setInvoiceId($invoiceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($invoiceId) && strlen($invoiceId) > 100) || (is_array($invoiceId) && count($invoiceId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($invoiceId) ? strlen($invoiceId) : count($invoiceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($invoiceId) && !is_string($invoiceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($invoiceId)), __LINE__);
        }
        $this->invoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get serviceId value
     * @return string
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param string $serviceId
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($serviceId) && strlen($serviceId) > 20) || (is_array($serviceId) && count($serviceId) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($serviceId) ? strlen($serviceId) : count($serviceId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get regNumber value
     * @return string
     */
    public function getRegNumber()
    {
        return $this->regNumber;
    }
    /**
     * Set regNumber value
     * @param string $regNumber
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 15) || (is_array($regNumber) && count($regNumber) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->regNumber = $regNumber;
        return $this;
    }
    /**
     * Get accountNumber value
     * @return string
     */
    public function getAccountNumber()
    {
        return $this->accountNumber;
    }
    /**
     * Set accountNumber value
     * @param string $accountNumber
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountNumber) && strlen($accountNumber) > 35) || (is_array($accountNumber) && count($accountNumber) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($accountNumber) ? strlen($accountNumber) : count($accountNumber)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($accountNumber) && !preg_match('/([0-9|A-Z])*/', $accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9|A-Z])*", "%s" given', var_export($accountNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->accountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get InvoiceParties value
     * @return \Lib\OmnivaService\StructType\InvoiceParties|null
     */
    public function getInvoiceParties()
    {
        return $this->InvoiceParties;
    }
    /**
     * Set InvoiceParties value
     * @param \Lib\OmnivaService\StructType\InvoiceParties $invoiceParties
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setInvoiceParties(\Lib\OmnivaService\StructType\InvoiceParties $invoiceParties = null)
    {
        $this->InvoiceParties = $invoiceParties;
        return $this;
    }
    /**
     * Get InvoiceInformation value
     * @return \Lib\OmnivaService\StructType\InvoiceInformation|null
     */
    public function getInvoiceInformation()
    {
        return $this->InvoiceInformation;
    }
    /**
     * Set InvoiceInformation value
     * @param \Lib\OmnivaService\StructType\InvoiceInformation $invoiceInformation
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setInvoiceInformation(\Lib\OmnivaService\StructType\InvoiceInformation $invoiceInformation = null)
    {
        $this->InvoiceInformation = $invoiceInformation;
        return $this;
    }
    /**
     * Get InvoiceSumGroup value
     * @return \Lib\OmnivaService\StructType\InvoiceSumGroup[]|null
     */
    public function getInvoiceSumGroup()
    {
        return $this->InvoiceSumGroup;
    }
    /**
     * Set InvoiceSumGroup value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\InvoiceSumGroup[] $invoiceSumGroup
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setInvoiceSumGroup(array $invoiceSumGroup = array())
    {
        foreach ($invoiceSumGroup as $invoiceInvoiceSumGroupItem) {
            // validation for constraint: itemType
            if (!$invoiceInvoiceSumGroupItem instanceof \Lib\OmnivaService\StructType\InvoiceSumGroup) {
                throw new \InvalidArgumentException(sprintf('The InvoiceSumGroup property can only contain items of \Lib\OmnivaService\StructType\InvoiceSumGroup, "%s" given', is_object($invoiceInvoiceSumGroupItem) ? get_class($invoiceInvoiceSumGroupItem) : gettype($invoiceInvoiceSumGroupItem)), __LINE__);
            }
        }
        $this->InvoiceSumGroup = $invoiceSumGroup;
        return $this;
    }
    /**
     * Add item to InvoiceSumGroup value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\InvoiceSumGroup $item
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function addToInvoiceSumGroup(\Lib\OmnivaService\StructType\InvoiceSumGroup $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\InvoiceSumGroup) {
            throw new \InvalidArgumentException(sprintf('The InvoiceSumGroup property can only contain items of \Lib\OmnivaService\StructType\InvoiceSumGroup, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InvoiceSumGroup[] = $item;
        return $this;
    }
    /**
     * Get InvoiceItem value
     * @return \Lib\OmnivaService\StructType\InvoiceItem|null
     */
    public function getInvoiceItem()
    {
        return $this->InvoiceItem;
    }
    /**
     * Set InvoiceItem value
     * @param \Lib\OmnivaService\StructType\InvoiceItem $invoiceItem
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setInvoiceItem(\Lib\OmnivaService\StructType\InvoiceItem $invoiceItem = null)
    {
        $this->InvoiceItem = $invoiceItem;
        return $this;
    }
    /**
     * Get AdditionalInformation value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getAdditionalInformation()
    {
        return $this->AdditionalInformation;
    }
    /**
     * Set AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $additionalInformation
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setAdditionalInformation(array $additionalInformation = array())
    {
        foreach ($additionalInformation as $invoiceAdditionalInformationItem) {
            // validation for constraint: itemType
            if (!$invoiceAdditionalInformationItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($invoiceAdditionalInformationItem) ? get_class($invoiceAdditionalInformationItem) : gettype($invoiceAdditionalInformationItem)), __LINE__);
            }
        }
        $this->AdditionalInformation = $additionalInformation;
        return $this;
    }
    /**
     * Add item to AdditionalInformation value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function addToAdditionalInformation(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The AdditionalInformation property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AdditionalInformation[] = $item;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \Lib\OmnivaService\StructType\PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \Lib\OmnivaService\StructType\PaymentInfo $paymentInfo
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setPaymentInfo(\Lib\OmnivaService\StructType\PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get factoring value
     * @return string|null
     */
    public function getFactoring()
    {
        return $this->factoring;
    }
    /**
     * Set factoring value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $factoring
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public function setFactoring($factoring = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($factoring)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $factoring, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->factoring = $factoring;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\Invoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
