<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImportError StructType
 * @subpackage Structs
 */
class ImportError extends AbstractStructBase
{
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * The ConnectionDimFrom
     * @var \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType
     */
    public $ConnectionDimFrom;
    /**
     * The ConnectionDimTo
     * @var \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType
     */
    public $ConnectionDimTo;
    /**
     * Constructor method for ImportError
     * @uses ImportError::setCode()
     * @uses ImportError::setMessage()
     * @uses ImportError::setConnectionDimFrom()
     * @uses ImportError::setConnectionDimTo()
     * @param string $code
     * @param string $message
     * @param \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimFrom
     * @param \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimTo
     */
    public function __construct($code = null, $message = null, \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimFrom = null, \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimTo = null)
    {
        $this
            ->setCode($code)
            ->setMessage($message)
            ->setConnectionDimFrom($connectionDimFrom)
            ->setConnectionDimTo($connectionDimTo);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Lib\OmnivaService\StructType\ImportError
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Lib\OmnivaService\StructType\ImportError
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get ConnectionDimFrom value
     * @return \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType|null
     */
    public function getConnectionDimFrom()
    {
        return $this->ConnectionDimFrom;
    }
    /**
     * Set ConnectionDimFrom value
     * @param \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimFrom
     * @return \Lib\OmnivaService\StructType\ImportError
     */
    public function setConnectionDimFrom(\Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimFrom = null)
    {
        $this->ConnectionDimFrom = $connectionDimFrom;
        return $this;
    }
    /**
     * Get ConnectionDimTo value
     * @return \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType|null
     */
    public function getConnectionDimTo()
    {
        return $this->ConnectionDimTo;
    }
    /**
     * Set ConnectionDimTo value
     * @param \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimTo
     * @return \Lib\OmnivaService\StructType\ImportError
     */
    public function setConnectionDimTo(\Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType $connectionDimTo = null)
    {
        $this->ConnectionDimTo = $connectionDimTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\ImportError
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
