<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExtensionRecord StructType
 * @subpackage Structs
 */
class ExtensionRecord extends AbstractStructBase
{
    /**
     * The InformationName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $InformationName;
    /**
     * The InformationContent
     * Meta informations extracted from the WSDL
     * - maxLength: 500
     * @var string
     */
    public $InformationContent;
    /**
     * The extensionId
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var anySimpleType
     */
    public $extensionId;
    /**
     * Constructor method for ExtensionRecord
     * @uses ExtensionRecord::setInformationName()
     * @uses ExtensionRecord::setInformationContent()
     * @uses ExtensionRecord::setExtensionId()
     * @param string $informationName
     * @param string $informationContent
     * @param anySimpleType $extensionId
     */
    public function __construct($informationName = null, $informationContent = null, anySimpleType $extensionId = null)
    {
        $this
            ->setInformationName($informationName)
            ->setInformationContent($informationContent)
            ->setExtensionId($extensionId);
    }
    /**
     * Get InformationName value
     * @return string|null
     */
    public function getInformationName()
    {
        return $this->InformationName;
    }
    /**
     * Set InformationName value
     * @param string $informationName
     * @return \Lib\OmnivaService\StructType\ExtensionRecord
     */
    public function setInformationName($informationName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($informationName) && strlen($informationName) > 100) || (is_array($informationName) && count($informationName) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($informationName) ? strlen($informationName) : count($informationName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($informationName) && !is_string($informationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informationName)), __LINE__);
        }
        $this->InformationName = $informationName;
        return $this;
    }
    /**
     * Get InformationContent value
     * @return string|null
     */
    public function getInformationContent()
    {
        return $this->InformationContent;
    }
    /**
     * Set InformationContent value
     * @param string $informationContent
     * @return \Lib\OmnivaService\StructType\ExtensionRecord
     */
    public function setInformationContent($informationContent = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($informationContent) && strlen($informationContent) > 500) || (is_array($informationContent) && count($informationContent) > 500)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 500 element(s) or a scalar of 500 character(s) at most, "%d" length given', is_scalar($informationContent) ? strlen($informationContent) : count($informationContent)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($informationContent) && !is_string($informationContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($informationContent)), __LINE__);
        }
        $this->InformationContent = $informationContent;
        return $this;
    }
    /**
     * Get extensionId value
     * @return anySimpleType|null
     */
    public function getExtensionId()
    {
        return $this->extensionId;
    }
    /**
     * Set extensionId value
     * @param anySimpleType $extensionId
     * @return \Lib\OmnivaService\StructType\ExtensionRecord
     */
    public function setExtensionId(anySimpleType $extensionId = null)
    {
        $this->extensionId = $extensionId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\ExtensionRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
