<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for E_Invoice StructType
 * Meta informations extracted from the WSDL
 * - documentation: root element
 * @subpackage Structs
 */
class E_Invoice extends AbstractStructBase
{
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - ref: Header
     * @var \Lib\OmnivaService\StructType\Header
     */
    public $Header;
    /**
     * The Invoice
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: Invoice
     * @var \Lib\OmnivaService\StructType\Invoice[]
     */
    public $Invoice;
    /**
     * Constructor method for E_Invoice
     * @uses E_Invoice::setHeader()
     * @uses E_Invoice::setInvoice()
     * @param \Lib\OmnivaService\StructType\Header $header
     * @param \Lib\OmnivaService\StructType\Invoice[] $invoice
     */
    public function __construct(\Lib\OmnivaService\StructType\Header $header = null, array $invoice = array())
    {
        $this
            ->setHeader($header)
            ->setInvoice($invoice);
    }
    /**
     * Get Header value
     * @return \Lib\OmnivaService\StructType\Header|null
     */
    public function getHeader()
    {
        return $this->Header;
    }
    /**
     * Set Header value
     * @param \Lib\OmnivaService\StructType\Header $header
     * @return \Lib\OmnivaService\StructType\E_Invoice
     */
    public function setHeader(\Lib\OmnivaService\StructType\Header $header = null)
    {
        $this->Header = $header;
        return $this;
    }
    /**
     * Get Invoice value
     * @return \Lib\OmnivaService\StructType\Invoice[]|null
     */
    public function getInvoice()
    {
        return $this->Invoice;
    }
    /**
     * Set Invoice value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\Invoice[] $invoice
     * @return \Lib\OmnivaService\StructType\E_Invoice
     */
    public function setInvoice(array $invoice = array())
    {
        foreach ($invoice as $e_InvoiceInvoiceItem) {
            // validation for constraint: itemType
            if (!$e_InvoiceInvoiceItem instanceof \Lib\OmnivaService\StructType\Invoice) {
                throw new \InvalidArgumentException(sprintf('The Invoice property can only contain items of \Lib\OmnivaService\StructType\Invoice, "%s" given', is_object($e_InvoiceInvoiceItem) ? get_class($e_InvoiceInvoiceItem) : gettype($e_InvoiceInvoiceItem)), __LINE__);
            }
        }
        $this->Invoice = $invoice;
        return $this;
    }
    /**
     * Add item to Invoice value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\Invoice $item
     * @return \Lib\OmnivaService\StructType\E_Invoice
     */
    public function addToInvoice(\Lib\OmnivaService\StructType\Invoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\Invoice) {
            throw new \InvalidArgumentException(sprintf('The Invoice property can only contain items of \Lib\OmnivaService\StructType\Invoice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Invoice[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\E_Invoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
