<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionRegistryRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Xml with supported client specific format is the request content
 * @subpackage Structs
 */
class DimensionRegistryRequestType extends AbstractStructBase
{
    /**
     * The format
     * Meta informations extracted from the WSDL
     * - documentation: Incoming data format. Currently available: AXAPTA
     * - use: required
     * @var string
     */
    public $format;
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * The replace
     * Meta informations extracted from the WSDL
     * - documentation: If whole client registry is sent and old one can be replaced entirely
     * - use: optional
     * @var string
     */
    public $replace;
    /**
     * The parse
     * Meta informations extracted from the WSDL
     * - documentation: If dimensions are sent in batches then final request has to be marked - end of transaction. If single request contains all dimensions then this is YES. This triggers actual dimension parsing
     * - use: optional
     * @var string
     */
    public $parse;
    /**
     * The parseConnections
     * Meta informations extracted from the WSDL
     * - documentation: Same as "parse". Deprecated
     * - use: optional
     * @var string
     */
    public $parseConnections;
    /**
     * Constructor method for DimensionRegistryRequestType
     * @uses DimensionRegistryRequestType::setFormat()
     * @uses DimensionRegistryRequestType::setAuthPhrase()
     * @uses DimensionRegistryRequestType::setAny()
     * @uses DimensionRegistryRequestType::setReplace()
     * @uses DimensionRegistryRequestType::setParse()
     * @uses DimensionRegistryRequestType::setParseConnections()
     * @param string $format
     * @param string $authPhrase
     * @param \DOMDocument $any
     * @param string $replace
     * @param string $parse
     * @param string $parseConnections
     */
    public function __construct($format = null, $authPhrase = null, \DOMDocument $any = null, $replace = null, $parse = null, $parseConnections = null)
    {
        $this
            ->setFormat($format)
            ->setAuthPhrase($authPhrase)
            ->setAny($any)
            ->setReplace($replace)
            ->setParse($parse)
            ->setParseConnections($parseConnections);
    }
    /**
     * Get format value
     * @return string
     */
    public function getFormat()
    {
        return $this->format;
    }
    /**
     * Set format value
     * @uses \Lib\OmnivaService\EnumType\RegistryFormatType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\RegistryFormatType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \Lib\OmnivaService\StructType\DimensionRegistryRequestType
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\RegistryFormatType::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $format, implode(', ', \Lib\OmnivaService\EnumType\RegistryFormatType::getValidValues())), __LINE__);
        }
        $this->format = $format;
        return $this;
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\DimensionRegistryRequestType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Lib\OmnivaService\StructType\DimensionRegistryRequestType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Lib\OmnivaService\StructType\DimensionRegistryRequestType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Get replace value
     * @return string|null
     */
    public function getReplace()
    {
        return $this->replace;
    }
    /**
     * Set replace value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $replace
     * @return \Lib\OmnivaService\StructType\DimensionRegistryRequestType
     */
    public function setReplace($replace = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($replace)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $replace, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->replace = $replace;
        return $this;
    }
    /**
     * Get parse value
     * @return string|null
     */
    public function getParse()
    {
        return $this->parse;
    }
    /**
     * Set parse value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parse
     * @return \Lib\OmnivaService\StructType\DimensionRegistryRequestType
     */
    public function setParse($parse = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($parse)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parse, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->parse = $parse;
        return $this;
    }
    /**
     * Get parseConnections value
     * @return string|null
     */
    public function getParseConnections()
    {
        return $this->parseConnections;
    }
    /**
     * Set parseConnections value
     * @uses \Lib\OmnivaService\EnumType\YesNoType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\YesNoType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $parseConnections
     * @return \Lib\OmnivaService\StructType\DimensionRegistryRequestType
     */
    public function setParseConnections($parseConnections = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\YesNoType::valueIsValid($parseConnections)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $parseConnections, implode(', ', \Lib\OmnivaService\EnumType\YesNoType::getValidValues())), __LINE__);
        }
        $this->parseConnections = $parseConnections;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\DimensionRegistryRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
