<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DimensionRegistryConnectionPartType StructType
 * @subpackage Structs
 */
class DimensionRegistryConnectionPartType extends AbstractStructBase
{
    /**
     * The Dimension
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $Dimension;
    /**
     * The DimensionNum
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $DimensionNum;
    /**
     * Constructor method for DimensionRegistryConnectionPartType
     * @uses DimensionRegistryConnectionPartType::setDimension()
     * @uses DimensionRegistryConnectionPartType::setDimensionNum()
     * @param string $dimension
     * @param string $dimensionNum
     */
    public function __construct($dimension = null, $dimensionNum = null)
    {
        $this
            ->setDimension($dimension)
            ->setDimensionNum($dimensionNum);
    }
    /**
     * Get Dimension value
     * @return string|null
     */
    public function getDimension()
    {
        return $this->Dimension;
    }
    /**
     * Set Dimension value
     * @param string $dimension
     * @return \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType
     */
    public function setDimension($dimension = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dimension) && strlen($dimension) > 100) || (is_array($dimension) && count($dimension) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($dimension) ? strlen($dimension) : count($dimension)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dimension) && !is_string($dimension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dimension)), __LINE__);
        }
        $this->Dimension = $dimension;
        return $this;
    }
    /**
     * Get DimensionNum value
     * @return string|null
     */
    public function getDimensionNum()
    {
        return $this->DimensionNum;
    }
    /**
     * Set DimensionNum value
     * @param string $dimensionNum
     * @return \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType
     */
    public function setDimensionNum($dimensionNum = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($dimensionNum) && strlen($dimensionNum) > 100) || (is_array($dimensionNum) && count($dimensionNum) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($dimensionNum) ? strlen($dimensionNum) : count($dimensionNum)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($dimensionNum) && !is_string($dimensionNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dimensionNum)), __LINE__);
        }
        $this->DimensionNum = $dimensionNum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\DimensionRegistryConnectionPartType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
