<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostReportExportRequestType StructType
 * @subpackage Structs
 */
class CostReportExportRequestType extends AbstractStructBase
{
    /**
     * The since
     * Meta informations extracted from the WSDL
     * - documentation: Only consider changes that have been made in EAK after this date. Cost report whose state has changed after this datum are returned.
     * - use: required
     * @var string
     */
    public $since;
    /**
     * The authPhrase
     * Meta informations extracted from the WSDL
     * - use: required
     * - documentation: Identifies and authorizes company making the request. Must be generated in EAK and inserted into settings of ERP.
     * - maxLength: 100
     * @var string
     */
    public $authPhrase;
    /**
     * The state
     * Meta informations extracted from the WSDL
     * - documentation: If at least one state is specified then only cost reports with this state are returned (if any).
     * @var string
     */
    public $state;
    /**
     * Constructor method for CostReportExportRequestType
     * @uses CostReportExportRequestType::setSince()
     * @uses CostReportExportRequestType::setAuthPhrase()
     * @uses CostReportExportRequestType::setState()
     * @param string $since
     * @param string $authPhrase
     * @param string $state
     */
    public function __construct($since = null, $authPhrase = null, $state = null)
    {
        $this
            ->setSince($since)
            ->setAuthPhrase($authPhrase)
            ->setState($state);
    }
    /**
     * Get since value
     * @return string
     */
    public function getSince()
    {
        return $this->since;
    }
    /**
     * Set since value
     * @param string $since
     * @return \Lib\OmnivaService\StructType\CostReportExportRequestType
     */
    public function setSince($since = null)
    {
        // validation for constraint: string
        if (!is_null($since) && !is_string($since)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($since)), __LINE__);
        }
        $this->since = $since;
        return $this;
    }
    /**
     * Get authPhrase value
     * @return string
     */
    public function getAuthPhrase()
    {
        return $this->authPhrase;
    }
    /**
     * Set authPhrase value
     * @param string $authPhrase
     * @return \Lib\OmnivaService\StructType\CostReportExportRequestType
     */
    public function setAuthPhrase($authPhrase = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($authPhrase) && strlen($authPhrase) > 100) || (is_array($authPhrase) && count($authPhrase) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($authPhrase) ? strlen($authPhrase) : count($authPhrase)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($authPhrase) && !is_string($authPhrase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($authPhrase)), __LINE__);
        }
        $this->authPhrase = $authPhrase;
        return $this;
    }
    /**
     * Get state value
     * @return string|null
     */
    public function getState()
    {
        return $this->state;
    }
    /**
     * Set state value
     * @uses \Lib\OmnivaService\EnumType\CostReportStateType::valueIsValid()
     * @uses \Lib\OmnivaService\EnumType\CostReportStateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \Lib\OmnivaService\StructType\CostReportExportRequestType
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\Lib\OmnivaService\EnumType\CostReportStateType::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $state, implode(', ', \Lib\OmnivaService\EnumType\CostReportStateType::getValidValues())), __LINE__);
        }
        $this->state = $state;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\CostReportExportRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
