<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillPartyRecord StructType
 * @subpackage Structs
 */
class BillPartyRecord extends AbstractStructBase
{
    /**
     * The UniqueCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 20
     * @var string
     */
    public $UniqueCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxLength: 70
     * - pattern: [ -ÿ]*
     * @var string
     */
    public $Name;
    /**
     * The DepId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $DepId;
    /**
     * The RegNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $RegNumber;
    /**
     * The VATRegNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 15
     * @var string
     */
    public $VATRegNumber;
    /**
     * The ContactData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ContactDataRecord
     */
    public $ContactData;
    /**
     * The AccountInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\AccountDataRecord[]
     */
    public $AccountInfo;
    /**
     * The Extension
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Lib\OmnivaService\StructType\ExtensionRecord[]
     */
    public $Extension;
    /**
     * Constructor method for BillPartyRecord
     * @uses BillPartyRecord::setUniqueCode()
     * @uses BillPartyRecord::setName()
     * @uses BillPartyRecord::setDepId()
     * @uses BillPartyRecord::setRegNumber()
     * @uses BillPartyRecord::setVATRegNumber()
     * @uses BillPartyRecord::setContactData()
     * @uses BillPartyRecord::setAccountInfo()
     * @uses BillPartyRecord::setExtension()
     * @param string $uniqueCode
     * @param string $name
     * @param string $depId
     * @param string $regNumber
     * @param string $vATRegNumber
     * @param \Lib\OmnivaService\StructType\ContactDataRecord $contactData
     * @param \Lib\OmnivaService\StructType\AccountDataRecord[] $accountInfo
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     */
    public function __construct($uniqueCode = null, $name = null, $depId = null, $regNumber = null, $vATRegNumber = null, \Lib\OmnivaService\StructType\ContactDataRecord $contactData = null, array $accountInfo = array(), array $extension = array())
    {
        $this
            ->setUniqueCode($uniqueCode)
            ->setName($name)
            ->setDepId($depId)
            ->setRegNumber($regNumber)
            ->setVATRegNumber($vATRegNumber)
            ->setContactData($contactData)
            ->setAccountInfo($accountInfo)
            ->setExtension($extension);
    }
    /**
     * Get UniqueCode value
     * @return string|null
     */
    public function getUniqueCode()
    {
        return $this->UniqueCode;
    }
    /**
     * Set UniqueCode value
     * @param string $uniqueCode
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setUniqueCode($uniqueCode = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($uniqueCode) && strlen($uniqueCode) > 20) || (is_array($uniqueCode) && count($uniqueCode) > 20)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 20 element(s) or a scalar of 20 character(s) at most, "%d" length given', is_scalar($uniqueCode) ? strlen($uniqueCode) : count($uniqueCode)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($uniqueCode) && !is_string($uniqueCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uniqueCode)), __LINE__);
        }
        $this->UniqueCode = $uniqueCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 70) || (is_array($name) && count($name) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($name) && !preg_match('/[ -ÿ]*/', $name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[ -ÿ]*", "%s" given', var_export($name, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get DepId value
     * @return string|null
     */
    public function getDepId()
    {
        return $this->DepId;
    }
    /**
     * Set DepId value
     * @param string $depId
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setDepId($depId = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($depId) && strlen($depId) > 100) || (is_array($depId) && count($depId) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($depId) ? strlen($depId) : count($depId)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($depId) && !is_string($depId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depId)), __LINE__);
        }
        $this->DepId = $depId;
        return $this;
    }
    /**
     * Get RegNumber value
     * @return string|null
     */
    public function getRegNumber()
    {
        return $this->RegNumber;
    }
    /**
     * Set RegNumber value
     * @param string $regNumber
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setRegNumber($regNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($regNumber) && strlen($regNumber) > 15) || (is_array($regNumber) && count($regNumber) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($regNumber) ? strlen($regNumber) : count($regNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($regNumber) && !is_string($regNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regNumber)), __LINE__);
        }
        $this->RegNumber = $regNumber;
        return $this;
    }
    /**
     * Get VATRegNumber value
     * @return string|null
     */
    public function getVATRegNumber()
    {
        return $this->VATRegNumber;
    }
    /**
     * Set VATRegNumber value
     * @param string $vATRegNumber
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setVATRegNumber($vATRegNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($vATRegNumber) && strlen($vATRegNumber) > 15) || (is_array($vATRegNumber) && count($vATRegNumber) > 15)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 15 element(s) or a scalar of 15 character(s) at most, "%d" length given', is_scalar($vATRegNumber) ? strlen($vATRegNumber) : count($vATRegNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($vATRegNumber) && !is_string($vATRegNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vATRegNumber)), __LINE__);
        }
        $this->VATRegNumber = $vATRegNumber;
        return $this;
    }
    /**
     * Get ContactData value
     * @return \Lib\OmnivaService\StructType\ContactDataRecord|null
     */
    public function getContactData()
    {
        return $this->ContactData;
    }
    /**
     * Set ContactData value
     * @param \Lib\OmnivaService\StructType\ContactDataRecord $contactData
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setContactData(\Lib\OmnivaService\StructType\ContactDataRecord $contactData = null)
    {
        $this->ContactData = $contactData;
        return $this;
    }
    /**
     * Get AccountInfo value
     * @return \Lib\OmnivaService\StructType\AccountDataRecord[]|null
     */
    public function getAccountInfo()
    {
        return $this->AccountInfo;
    }
    /**
     * Set AccountInfo value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AccountDataRecord[] $accountInfo
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setAccountInfo(array $accountInfo = array())
    {
        foreach ($accountInfo as $billPartyRecordAccountInfoItem) {
            // validation for constraint: itemType
            if (!$billPartyRecordAccountInfoItem instanceof \Lib\OmnivaService\StructType\AccountDataRecord) {
                throw new \InvalidArgumentException(sprintf('The AccountInfo property can only contain items of \Lib\OmnivaService\StructType\AccountDataRecord, "%s" given', is_object($billPartyRecordAccountInfoItem) ? get_class($billPartyRecordAccountInfoItem) : gettype($billPartyRecordAccountInfoItem)), __LINE__);
            }
        }
        $this->AccountInfo = $accountInfo;
        return $this;
    }
    /**
     * Add item to AccountInfo value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\AccountDataRecord $item
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function addToAccountInfo(\Lib\OmnivaService\StructType\AccountDataRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\AccountDataRecord) {
            throw new \InvalidArgumentException(sprintf('The AccountInfo property can only contain items of \Lib\OmnivaService\StructType\AccountDataRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountInfo[] = $item;
        return $this;
    }
    /**
     * Get Extension value
     * @return \Lib\OmnivaService\StructType\ExtensionRecord[]|null
     */
    public function getExtension()
    {
        return $this->Extension;
    }
    /**
     * Set Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord[] $extension
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function setExtension(array $extension = array())
    {
        foreach ($extension as $billPartyRecordExtensionItem) {
            // validation for constraint: itemType
            if (!$billPartyRecordExtensionItem instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
                throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($billPartyRecordExtensionItem) ? get_class($billPartyRecordExtensionItem) : gettype($billPartyRecordExtensionItem)), __LINE__);
            }
        }
        $this->Extension = $extension;
        return $this;
    }
    /**
     * Add item to Extension value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\ExtensionRecord $item
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public function addToExtension(\Lib\OmnivaService\StructType\ExtensionRecord $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\ExtensionRecord) {
            throw new \InvalidArgumentException(sprintf('The Extension property can only contain items of \Lib\OmnivaService\StructType\ExtensionRecord, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Extension[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\BillPartyRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
