<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Balance StructType
 * @subpackage Structs
 */
class Balance extends AbstractStructBase
{
    /**
     * The BalanceDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BalanceDate;
    /**
     * The BalanceBegin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 2
     * @var float
     */
    public $BalanceBegin;
    /**
     * The BalanceEnd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 2
     * @var float
     */
    public $BalanceEnd;
    /**
     * Constructor method for Balance
     * @uses Balance::setBalanceDate()
     * @uses Balance::setBalanceBegin()
     * @uses Balance::setBalanceEnd()
     * @param string $balanceDate
     * @param float $balanceBegin
     * @param float $balanceEnd
     */
    public function __construct($balanceDate = null, $balanceBegin = null, $balanceEnd = null)
    {
        $this
            ->setBalanceDate($balanceDate)
            ->setBalanceBegin($balanceBegin)
            ->setBalanceEnd($balanceEnd);
    }
    /**
     * Get BalanceDate value
     * @return string|null
     */
    public function getBalanceDate()
    {
        return $this->BalanceDate;
    }
    /**
     * Set BalanceDate value
     * @param string $balanceDate
     * @return \Lib\OmnivaService\StructType\Balance
     */
    public function setBalanceDate($balanceDate = null)
    {
        // validation for constraint: string
        if (!is_null($balanceDate) && !is_string($balanceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($balanceDate)), __LINE__);
        }
        $this->BalanceDate = $balanceDate;
        return $this;
    }
    /**
     * Get BalanceBegin value
     * @return float|null
     */
    public function getBalanceBegin()
    {
        return $this->BalanceBegin;
    }
    /**
     * Set BalanceBegin value
     * @param float $balanceBegin
     * @return \Lib\OmnivaService\StructType\Balance
     */
    public function setBalanceBegin($balanceBegin = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balanceBegin) && strlen(substr($balanceBegin, strpos($balanceBegin, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balanceBegin, strpos($balanceBegin, '.') + 1))), __LINE__);
        }
        $this->BalanceBegin = $balanceBegin;
        return $this;
    }
    /**
     * Get BalanceEnd value
     * @return float|null
     */
    public function getBalanceEnd()
    {
        return $this->BalanceEnd;
    }
    /**
     * Set BalanceEnd value
     * @param float $balanceEnd
     * @return \Lib\OmnivaService\StructType\Balance
     */
    public function setBalanceEnd($balanceEnd = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($balanceEnd) && strlen(substr($balanceEnd, strpos($balanceEnd, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($balanceEnd, strpos($balanceEnd, '.') + 1))), __LINE__);
        }
        $this->BalanceEnd = $balanceEnd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\Balance
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
