<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionRecord StructType
 * @subpackage Structs
 */
class AdditionRecord extends AbstractStructBase
{
    /**
     * The addCode
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $addCode;
    /**
     * The AddContent
     * Meta informations extracted from the WSDL
     * - maxLength: 100
     * @var string
     */
    public $AddContent;
    /**
     * The AddRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - fractionDigits: 2
     * @var float
     */
    public $AddRate;
    /**
     * The AddSum
     * Meta informations extracted from the WSDL
     * - fractionDigits: 4
     * @var float
     */
    public $AddSum;
    /**
     * Constructor method for AdditionRecord
     * @uses AdditionRecord::setAddCode()
     * @uses AdditionRecord::setAddContent()
     * @uses AdditionRecord::setAddRate()
     * @uses AdditionRecord::setAddSum()
     * @param string $addCode
     * @param string $addContent
     * @param float $addRate
     * @param float $addSum
     */
    public function __construct($addCode = null, $addContent = null, $addRate = null, $addSum = null)
    {
        $this
            ->setAddCode($addCode)
            ->setAddContent($addContent)
            ->setAddRate($addRate)
            ->setAddSum($addSum);
    }
    /**
     * Get addCode value
     * @return string
     */
    public function getAddCode()
    {
        return $this->addCode;
    }
    /**
     * Set addCode value
     * @param string $addCode
     * @return \Lib\OmnivaService\StructType\AdditionRecord
     */
    public function setAddCode($addCode = null)
    {
        // validation for constraint: string
        if (!is_null($addCode) && !is_string($addCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addCode)), __LINE__);
        }
        $this->addCode = $addCode;
        return $this;
    }
    /**
     * Get AddContent value
     * @return string|null
     */
    public function getAddContent()
    {
        return $this->AddContent;
    }
    /**
     * Set AddContent value
     * @param string $addContent
     * @return \Lib\OmnivaService\StructType\AdditionRecord
     */
    public function setAddContent($addContent = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($addContent) && strlen($addContent) > 100) || (is_array($addContent) && count($addContent) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($addContent) ? strlen($addContent) : count($addContent)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($addContent) && !is_string($addContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($addContent)), __LINE__);
        }
        $this->AddContent = $addContent;
        return $this;
    }
    /**
     * Get AddRate value
     * @return float|null
     */
    public function getAddRate()
    {
        return $this->AddRate;
    }
    /**
     * Set AddRate value
     * @param float $addRate
     * @return \Lib\OmnivaService\StructType\AdditionRecord
     */
    public function setAddRate($addRate = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($addRate) && strlen(substr($addRate, strpos($addRate, '.') + 1)) !== 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 2 fraction digits, "%d" given', strlen(substr($addRate, strpos($addRate, '.') + 1))), __LINE__);
        }
        $this->AddRate = $addRate;
        return $this;
    }
    /**
     * Get AddSum value
     * @return float|null
     */
    public function getAddSum()
    {
        return $this->AddSum;
    }
    /**
     * Set AddSum value
     * @param float $addSum
     * @return \Lib\OmnivaService\StructType\AdditionRecord
     */
    public function setAddSum($addSum = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($addSum) && strlen(substr($addSum, strpos($addSum, '.') + 1)) !== 4) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 4 fraction digits, "%d" given', strlen(substr($addSum, strpos($addSum, '.') + 1))), __LINE__);
        }
        $this->AddSum = $addSum;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\AdditionRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
