<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingRecord StructType
 * @subpackage Structs
 */
class AccountingRecord extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $Description;
    /**
     * The JournalEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Lib\OmnivaService\StructType\JournalEntry[]
     */
    public $JournalEntry;
    /**
     * Constructor method for AccountingRecord
     * @uses AccountingRecord::setDescription()
     * @uses AccountingRecord::setJournalEntry()
     * @param string $description
     * @param \Lib\OmnivaService\StructType\JournalEntry[] $journalEntry
     */
    public function __construct($description = null, array $journalEntry = array())
    {
        $this
            ->setDescription($description)
            ->setJournalEntry($journalEntry);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Lib\OmnivaService\StructType\AccountingRecord
     */
    public function setDescription($description = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($description) && strlen($description) > 100) || (is_array($description) && count($description) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($description) ? strlen($description) : count($description)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get JournalEntry value
     * @return \Lib\OmnivaService\StructType\JournalEntry[]|null
     */
    public function getJournalEntry()
    {
        return $this->JournalEntry;
    }
    /**
     * Set JournalEntry value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\JournalEntry[] $journalEntry
     * @return \Lib\OmnivaService\StructType\AccountingRecord
     */
    public function setJournalEntry(array $journalEntry = array())
    {
        foreach ($journalEntry as $accountingRecordJournalEntryItem) {
            // validation for constraint: itemType
            if (!$accountingRecordJournalEntryItem instanceof \Lib\OmnivaService\StructType\JournalEntry) {
                throw new \InvalidArgumentException(sprintf('The JournalEntry property can only contain items of \Lib\OmnivaService\StructType\JournalEntry, "%s" given', is_object($accountingRecordJournalEntryItem) ? get_class($accountingRecordJournalEntryItem) : gettype($accountingRecordJournalEntryItem)), __LINE__);
            }
        }
        $this->JournalEntry = $journalEntry;
        return $this;
    }
    /**
     * Add item to JournalEntry value
     * @throws \InvalidArgumentException
     * @param \Lib\OmnivaService\StructType\JournalEntry $item
     * @return \Lib\OmnivaService\StructType\AccountingRecord
     */
    public function addToJournalEntry(\Lib\OmnivaService\StructType\JournalEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Lib\OmnivaService\StructType\JournalEntry) {
            throw new \InvalidArgumentException(sprintf('The JournalEntry property can only contain items of \Lib\OmnivaService\StructType\JournalEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->JournalEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\AccountingRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
