<?php

namespace Lib\OmnivaService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountDataRecord StructType
 * @subpackage Structs
 */
class AccountDataRecord extends AbstractStructBase
{
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxLength: 35
     * - pattern: ([0-9|A-Z])*
     * @var string
     */
    public $AccountNumber;
    /**
     * The IBAN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 35
     * - pattern: ([0-9|A-Z])*
     * @var string
     */
    public $IBAN;
    /**
     * The BIC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 11
     * @var string
     */
    public $BIC;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxLength: 70
     * - pattern: [ -ÿ]*
     * @var string
     */
    public $BankName;
    /**
     * Constructor method for AccountDataRecord
     * @uses AccountDataRecord::setAccountNumber()
     * @uses AccountDataRecord::setIBAN()
     * @uses AccountDataRecord::setBIC()
     * @uses AccountDataRecord::setBankName()
     * @param string $accountNumber
     * @param string $iBAN
     * @param string $bIC
     * @param string $bankName
     */
    public function __construct($accountNumber = null, $iBAN = null, $bIC = null, $bankName = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setIBAN($iBAN)
            ->setBIC($bIC)
            ->setBankName($bankName);
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \Lib\OmnivaService\StructType\AccountDataRecord
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($accountNumber) && strlen($accountNumber) > 35) || (is_array($accountNumber) && count($accountNumber) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($accountNumber) ? strlen($accountNumber) : count($accountNumber)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($accountNumber) && !preg_match('/([0-9|A-Z])*/', $accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9|A-Z])*", "%s" given', var_export($accountNumber, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \Lib\OmnivaService\StructType\AccountDataRecord
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iBAN) && strlen($iBAN) > 35) || (is_array($iBAN) && count($iBAN) > 35)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 35 element(s) or a scalar of 35 character(s) at most, "%d" length given', is_scalar($iBAN) ? strlen($iBAN) : count($iBAN)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($iBAN) && !preg_match('/([0-9|A-Z])*/', $iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "([0-9|A-Z])*", "%s" given', var_export($iBAN, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return $this->BIC;
    }
    /**
     * Set BIC value
     * @param string $bIC
     * @return \Lib\OmnivaService\StructType\AccountDataRecord
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bIC) && strlen($bIC) > 11) || (is_array($bIC) && count($bIC) > 11)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 11 element(s) or a scalar of 11 character(s) at most, "%d" length given', is_scalar($bIC) ? strlen($bIC) : count($bIC)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bIC)), __LINE__);
        }
        $this->BIC = $bIC;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \Lib\OmnivaService\StructType\AccountDataRecord
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($bankName) && strlen($bankName) > 70) || (is_array($bankName) && count($bankName) > 70)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 70 element(s) or a scalar of 70 character(s) at most, "%d" length given', is_scalar($bankName) ? strlen($bankName) : count($bankName)), __LINE__);
        }
        // validation for constraint: pattern
        if (is_scalar($bankName) && !preg_match('/[ -ÿ]*/', $bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[ -ÿ]*", "%s" given', var_export($bankName, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Lib\OmnivaService\StructType\AccountDataRecord
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
