<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sale ServiceType
 * @subpackage Services
 */
class Sale extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SaleInvoiceBuyStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType $saleInvoiceBuyStatusRequest
     * @return \Lib\OmnivaService\StructType\SaleInvoiceBuyStatusResponseType|bool
     */
    public function SaleInvoiceBuyStatus(\Lib\OmnivaService\StructType\SaleInvoiceBuyStatusRequestType $saleInvoiceBuyStatusRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SaleInvoiceBuyStatus($saleInvoiceBuyStatusRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SaleInvoiceExport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\SaleInvoiceExportReqType $saleInvoiceExportRequest
     * @return \Lib\OmnivaService\StructType\EInvoiceRespoonseType|bool
     */
    public function SaleInvoiceExport(\Lib\OmnivaService\StructType\SaleInvoiceExportReqType $saleInvoiceExportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->SaleInvoiceExport($saleInvoiceExportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\EInvoiceRespoonseType|\Lib\OmnivaService\StructType\SaleInvoiceBuyStatusResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
