<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reject ServiceType
 * @subpackage Services
 */
class Reject extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RejectConfirmation
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\RejectConfirmationRequestType $rejectConfirmationRequest
     * @return \Lib\OmnivaService\StructType\SimpleResponseType|bool
     */
    public function RejectConfirmation(\Lib\OmnivaService\StructType\RejectConfirmationRequestType $rejectConfirmationRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->RejectConfirmation($rejectConfirmationRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\SimpleResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
