<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Registry ServiceType
 * @subpackage Services
 */
class Registry extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RegistryImport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\RegistryImportRequest $registryImportRequest
     * @return \Lib\OmnivaService\StructType\RegistryImportResponse|bool
     */
    public function RegistryImport(\Lib\OmnivaService\StructType\RegistryImportRequest $registryImportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->RegistryImport($registryImportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\RegistryImportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
