<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Invoice ServiceType
 * @subpackage Services
 */
class Invoice extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InvoiceAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\InvoiceAttachmentRequestType $invoiceAttachmentRequest
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentResponseType|bool
     */
    public function InvoiceAttachment(\Lib\OmnivaService\StructType\InvoiceAttachmentRequestType $invoiceAttachmentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->InvoiceAttachment($invoiceAttachmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\InvoiceAttachmentResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
