<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cost ServiceType
 * @subpackage Services
 */
class Cost extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CostReportExport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\CostReportExportRequestType $costReportExportRequest
     * @return \Lib\OmnivaService\StructType\CostReportExportResponseType|bool
     */
    public function CostReportExport(\Lib\OmnivaService\StructType\CostReportExportRequestType $costReportExportRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CostReportExport($costReportExportRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CostReportAttachment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\CostReportAttachmentRequestType $costReportAttachmentRequest
     * @return \Lib\OmnivaService\StructType\CostReportAttachmentResponseType|bool
     */
    public function CostReportAttachment(\Lib\OmnivaService\StructType\CostReportAttachmentRequestType $costReportAttachmentRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->CostReportAttachment($costReportAttachmentRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\CostReportAttachmentResponseType|\Lib\OmnivaService\StructType\CostReportExportResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
