<?php

namespace Lib\OmnivaService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Account ServiceType
 * @subpackage Services
 */
class Account extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AccountPlan
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Lib\OmnivaService\StructType\AccountPlanRequestType $accountPlanRequest
     * @return \Lib\OmnivaService\StructType\SimpleResponseType|bool
     */
    public function AccountPlan(\Lib\OmnivaService\StructType\AccountPlanRequestType $accountPlanRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->AccountPlan($accountPlanRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Lib\OmnivaService\StructType\SimpleResponseType
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
