<?php

namespace Lib\OmnivaService\EnumType;

/**
 * This class stands for RejectTypeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Types of confirmation circle rejections
 * @subpackage Enumerations
 */
class RejectTypeType
{
    /**
     * Constant for value 'REJECT'
     * @return string 'REJECT'
     */
    const VALUE_REJECT = 'REJECT';
    /**
     * Constant for value 'REJECT_AND_RESEND'
     * @return string 'REJECT_AND_RESEND'
     */
    const VALUE_REJECT_AND_RESEND = 'REJECT_AND_RESEND';
    /**
     * Constant for value 'REJECT_AND_RESEND_TO_LAST'
     * @return string 'REJECT_AND_RESEND_TO_LAST'
     */
    const VALUE_REJECT_AND_RESEND_TO_LAST = 'REJECT_AND_RESEND_TO_LAST';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_REJECT
     * @uses self::VALUE_REJECT_AND_RESEND
     * @uses self::VALUE_REJECT_AND_RESEND_TO_LAST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_REJECT,
            self::VALUE_REJECT_AND_RESEND,
            self::VALUE_REJECT_AND_RESEND_TO_LAST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
