<?php

namespace Lib\OmnivaService\EnumType;

/**
 * This class stands for RegistryFormatType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Possible formats supported by registry import (not all registries support each type)
 * @subpackage Enumerations
 */
class RegistryFormatType
{
    /**
     * Constant for value 'STANDARD'
     * @return string 'STANDARD'
     */
    const VALUE_STANDARD = 'STANDARD';
    /**
     * Constant for value 'AXAPTA'
     * @return string 'AXAPTA'
     */
    const VALUE_AXAPTA = 'AXAPTA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STANDARD
     * @uses self::VALUE_AXAPTA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STANDARD,
            self::VALUE_AXAPTA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
