<?php

namespace Lib\OmnivaService\EnumType;

/**
 * This class stands for BuyInvoiceStateType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Types of buy invoices that can be obtained from EAK
 * @subpackage Enumerations
 */
class BuyInvoiceStateType
{
    /**
     * Constant for value 'RECEIVED'
     * @return string 'RECEIVED'
     */
    const VALUE_RECEIVED = 'RECEIVED';
    /**
     * Constant for value 'BEING_VERIFIED'
     * @return string 'BEING_VERIFIED'
     */
    const VALUE_BEING_VERIFIED = 'BEING_VERIFIED';
    /**
     * Constant for value 'VERIFIED'
     * @return string 'VERIFIED'
     */
    const VALUE_VERIFIED = 'VERIFIED';
    /**
     * Constant for value 'FORPAY'
     * @return string 'FORPAY'
     */
    const VALUE_FORPAY = 'FORPAY';
    /**
     * Constant for value 'DECLINED'
     * @return string 'DECLINED'
     */
    const VALUE_DECLINED = 'DECLINED';
    /**
     * Constant for value 'RETURNED_TO_SENDER'
     * @return string 'RETURNED_TO_SENDER'
     */
    const VALUE_RETURNED_TO_SENDER = 'RETURNED_TO_SENDER';
    /**
     * Constant for value 'PAID'
     * @return string 'PAID'
     */
    const VALUE_PAID = 'PAID';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_RECEIVED
     * @uses self::VALUE_BEING_VERIFIED
     * @uses self::VALUE_VERIFIED
     * @uses self::VALUE_FORPAY
     * @uses self::VALUE_DECLINED
     * @uses self::VALUE_RETURNED_TO_SENDER
     * @uses self::VALUE_PAID
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_RECEIVED,
            self::VALUE_BEING_VERIFIED,
            self::VALUE_VERIFIED,
            self::VALUE_FORPAY,
            self::VALUE_DECLINED,
            self::VALUE_RETURNED_TO_SENDER,
            self::VALUE_PAID,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
